/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.push;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;

public enum PushProtocol {
    WEBSOCKET{

        @Override
        public Object getHandshakeCompleteEvent() {
            return WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE;
        }

        @Override
        public String getPath() {
            return "/ws";
        }

        @Override
        public ChannelFuture sendPushMessage(ChannelHandlerContext ctx, ByteBuf mesg) {
            TextWebSocketFrame wsf = new TextWebSocketFrame(mesg);
            return ctx.channel().writeAndFlush((Object)wsf);
        }

        @Override
        public ChannelFuture sendPing(ChannelHandlerContext ctx) {
            return ctx.channel().writeAndFlush((Object)new PingWebSocketFrame());
        }

        @Override
        public Object goAwayMessage() {
            return new TextWebSocketFrame("_CLOSE_");
        }

        @Override
        public Object serverClosingConnectionMessage(int statusCode, String reasonText) {
            return new CloseWebSocketFrame(statusCode, reasonText);
        }
    }
    ,
    SSE{
        private static final String SSE_HANDSHAKE_COMPLETE_EVENT = "sse_handshake_complete";
        private static final String SSE_PREAMBLE = "event: push\r\ndata: ";
        private static final String SSE_TERMINATION = "\r\n\r\n";
        private static final String SSE_PING = "event: ping\r\ndata: ping\r\n\r\n";

        @Override
        public Object getHandshakeCompleteEvent() {
            return SSE_HANDSHAKE_COMPLETE_EVENT;
        }

        @Override
        public String getPath() {
            return "/sse";
        }

        @Override
        public ChannelFuture sendPushMessage(ChannelHandlerContext ctx, ByteBuf mesg) {
            ByteBuf newBuff = ctx.alloc().buffer();
            newBuff.ensureWritable(SSE_PREAMBLE.length());
            newBuff.writeCharSequence((CharSequence)SSE_PREAMBLE, Charsets.UTF_8);
            newBuff.ensureWritable(mesg.writableBytes());
            newBuff.writeBytes(mesg);
            newBuff.ensureWritable(SSE_TERMINATION.length());
            newBuff.writeCharSequence((CharSequence)SSE_TERMINATION, Charsets.UTF_8);
            mesg.release();
            return ctx.channel().writeAndFlush((Object)newBuff);
        }

        @Override
        public ChannelFuture sendPing(ChannelHandlerContext ctx) {
            ByteBuf newBuff = ctx.alloc().buffer();
            newBuff.ensureWritable(SSE_PING.length());
            newBuff.writeCharSequence((CharSequence)SSE_PING, Charsets.UTF_8);
            return ctx.channel().writeAndFlush((Object)newBuff);
        }

        @Override
        public Object goAwayMessage() {
            return "event: goaway\r\ndata: _CLOSE_\r\n\r\n";
        }

        @Override
        public Object serverClosingConnectionMessage(int statusCode, String reasonText) {
            return "event: close\r\ndata: " + statusCode + " " + reasonText + SSE_TERMINATION;
        }
    };


    public final void sendErrorAndClose(ChannelHandlerContext ctx, int statusCode, String reasonText) {
        Object mesg = this.serverClosingConnectionMessage(statusCode, reasonText);
        ctx.writeAndFlush(mesg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public abstract Object getHandshakeCompleteEvent();

    public abstract String getPath();

    public abstract ChannelFuture sendPushMessage(ChannelHandlerContext var1, ByteBuf var2);

    public abstract ChannelFuture sendPing(ChannelHandlerContext var1);

    public abstract Object goAwayMessage();

    public abstract Object serverClosingConnectionMessage(int var1, String var2);
}

