/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.push;

import com.google.common.base.Strings;
import com.netflix.zuul.message.http.Cookies;
import com.netflix.zuul.netty.server.push.PushProtocol;
import com.netflix.zuul.netty.server.push.PushUserAuth;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class PushAuthHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String pushConnectionPath;
    private final String originDomain;
    public static final String NAME = "push_auth_handler";
    private static Logger logger = LoggerFactory.getLogger(PushAuthHandler.class);

    public PushAuthHandler(String pushConnectionPath, String originDomain) {
        this.pushConnectionPath = pushConnectionPath;
        this.originDomain = originDomain;
    }

    public final void sendHttpResponse(HttpRequest req, ChannelHandlerContext ctx, HttpResponseStatus status) {
        boolean closeConn;
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        resp.headers().add("Content-Length", (Object)"0");
        boolean bl = closeConn = status != HttpResponseStatus.OK || !HttpUtil.isKeepAlive((HttpMessage)req);
        if (closeConn) {
            resp.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Close");
        }
        ChannelFuture cf = ctx.channel().writeAndFlush((Object)resp);
        if (closeConn) {
            cf.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected final void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (req.method() != HttpMethod.GET) {
            this.sendHttpResponse((HttpRequest)req, ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String path = req.uri();
        if ("/healthcheck".equals(path)) {
            this.sendHttpResponse((HttpRequest)req, ctx, HttpResponseStatus.OK);
        } else if (this.pushConnectionPath.equals(path)) {
            String origin = req.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
            if (PushProtocol.WEBSOCKET.getPath().equals(this.pushConnectionPath) && (origin == null || !origin.toLowerCase().endsWith(this.originDomain))) {
                logger.error("Invalid Origin header {} in WebSocket upgrade request", (Object)origin);
                this.sendHttpResponse((HttpRequest)req, ctx, HttpResponseStatus.BAD_REQUEST);
            } else if (this.isDelayedAuth(req, ctx)) {
                ctx.fireChannelRead((Object)req.retain());
            } else {
                PushUserAuth authEvent = this.doAuth(req);
                if (authEvent.isSuccess()) {
                    ctx.fireChannelRead((Object)req.retain());
                    ctx.fireUserEventTriggered((Object)authEvent);
                } else {
                    logger.warn("Auth failed: {}", (Object)authEvent.statusCode());
                    this.sendHttpResponse((HttpRequest)req, ctx, HttpResponseStatus.valueOf((int)authEvent.statusCode()));
                }
            }
        } else {
            this.sendHttpResponse((HttpRequest)req, ctx, HttpResponseStatus.NOT_FOUND);
        }
    }

    protected final Cookies parseCookies(FullHttpRequest req) {
        Cookies cookies = new Cookies();
        String cookieStr = req.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (!Strings.isNullOrEmpty((String)cookieStr)) {
            Set decoded = CookieDecoder.decode((String)cookieStr, (boolean)false);
            decoded.forEach(cookie -> cookies.add((Cookie)cookie));
        }
        return cookies;
    }

    protected abstract boolean isDelayedAuth(FullHttpRequest var1, ChannelHandlerContext var2);

    protected abstract PushUserAuth doAuth(FullHttpRequest var1);
}

