/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.RequestCompleteHandler;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.message.Header;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.netty.server.ClientRequestReceiver;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientResponseWriter
extends ChannelInboundHandlerAdapter {
    private static final Registry NOOP_REGISTRY = new NoopRegistry();
    private final RequestCompleteHandler requestCompleteHandler;
    private final Counter responseBeforeReceivedLastContentCounter;
    private boolean isHandlingRequest;
    private boolean startedSendingResponseToClient;
    private boolean closeConnection;
    private HttpResponseMessage zuulResponse;
    private static final Logger LOG = LoggerFactory.getLogger(ClientResponseWriter.class);

    public ClientResponseWriter(RequestCompleteHandler requestCompleteHandler) {
        this(requestCompleteHandler, NOOP_REGISTRY);
    }

    public ClientResponseWriter(RequestCompleteHandler requestCompleteHandler, Registry registry) {
        this.requestCompleteHandler = requestCompleteHandler;
        this.responseBeforeReceivedLastContentCounter = registry.counter("server.http.requests.responseBeforeReceivedLastContent");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        if (msg instanceof HttpResponseMessage) {
            HttpResponseMessage resp = (HttpResponseMessage)msg;
            if (this.skipProcessing(resp)) {
                return;
            }
            if (!this.isHandlingRequest || this.startedSendingResponseToClient) {
                resp.disposeBufferedBody();
                if (this.zuulResponse != null) {
                    this.zuulResponse.disposeBufferedBody();
                }
                ctx.close();
                return;
            }
            this.startedSendingResponseToClient = true;
            this.zuulResponse = resp;
            if ("close".equalsIgnoreCase(this.zuulResponse.getHeaders().getFirst("Connection"))) {
                this.closeConnection = true;
            }
            channel.attr(ClientRequestReceiver.ATTR_ZUUL_RESP).set((Object)this.zuulResponse);
            if (channel.isActive()) {
                StatusCategory status;
                if (!ClientRequestReceiver.isLastContentReceivedForChannel(channel) && !ZuulStatusCategory.FAILURE_CLIENT_TIMEOUT.equals(status = StatusCategoryUtils.getStatusCategory(ClientRequestReceiver.getRequestFromChannel(channel)))) {
                    this.responseBeforeReceivedLastContentCounter.increment();
                    LOG.warn("Writing response to client channel before have received the LastContent of request! " + this.zuulResponse.getInboundRequest().getInfoForLogging() + ", " + ChannelUtils.channelInfoForLogging(channel));
                }
                channel.write((Object)this.buildHttpResponse(this.zuulResponse));
                ClientResponseWriter.writeBufferedBodyContent(this.zuulResponse, channel);
                channel.flush();
            } else {
                channel.close();
            }
        } else if (msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            if (channel.isActive()) {
                channel.writeAndFlush((Object)chunk);
            } else {
                chunk.release();
                channel.close();
            }
        } else {
            ReferenceCountUtil.release((Object)msg);
            throw new ZuulException("Received invalid message from origin", true);
        }
    }

    protected boolean skipProcessing(HttpResponseMessage resp) {
        return false;
    }

    private static void writeBufferedBodyContent(HttpResponseMessage zuulResponse, Channel channel) {
        zuulResponse.getBodyContents().forEach(chunk -> channel.write((Object)chunk.retain()));
    }

    private HttpResponse buildHttpResponse(HttpResponseMessage zuulResp) {
        HttpRequestInfo zuulRequest = zuulResp.getInboundRequest();
        String inboundProtocol = zuulRequest.getProtocol();
        HttpVersion responseHttpVersion = inboundProtocol.startsWith("HTTP/1") ? HttpVersion.valueOf((String)inboundProtocol) : HttpVersion.HTTP_1_1;
        DefaultHttpResponse nativeResponse = new DefaultHttpResponse(responseHttpVersion, HttpResponseStatus.valueOf((int)zuulResp.getStatus()), false, false);
        HttpHeaders nativeHeaders = nativeResponse.headers();
        for (Header entry : zuulResp.getHeaders().entries()) {
            nativeHeaders.add(entry.getKey(), (Object)entry.getValue());
        }
        if (!HttpUtil.isContentLengthSet((HttpMessage)nativeResponse) && !HttpUtil.isTransferEncodingChunked((HttpMessage)nativeResponse)) {
            nativeResponse.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        HttpRequest nativeReq = (HttpRequest)zuulResp.getContext().get("_netty_http_request");
        if (!this.closeConnection && HttpUtil.isKeepAlive((HttpMessage)nativeReq)) {
            HttpUtil.setKeepAlive((HttpMessage)nativeResponse, (boolean)true);
        } else {
            nativeResponse.headers().set("Connection", (Object)"close");
        }
        if (nativeReq.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            String streamId = nativeReq.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            nativeResponse.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        return nativeResponse;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpLifecycleChannelHandler.StartEvent) {
            this.isHandlingRequest = true;
            this.startedSendingResponseToClient = false;
            this.closeConnection = false;
            this.zuulResponse = null;
        } else if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            HttpResponse response = ((HttpLifecycleChannelHandler.CompleteEvent)evt).getResponse();
            if (response != null && "close".equalsIgnoreCase(response.headers().get("Connection"))) {
                this.closeConnection = true;
            }
            if (this.zuulResponse != null) {
                this.zuulResponse.disposeBufferedBody();
            }
            this.handleComplete(ctx.channel());
            HttpLifecycleChannelHandler.CompleteEvent completeEvent = (HttpLifecycleChannelHandler.CompleteEvent)evt;
            HttpLifecycleChannelHandler.CompleteReason reason = completeEvent.getReason();
            if (reason == HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE || reason == HttpLifecycleChannelHandler.CompleteReason.INACTIVE) {
                if (!this.closeConnection) {
                    ctx.channel().read();
                } else {
                    ctx.close();
                }
            } else {
                if (this.isHandlingRequest) {
                    LOG.warn("Received complete event while still handling the request. With reason: " + reason.name() + " -- " + ChannelUtils.channelInfoForLogging(ctx.channel()));
                }
                ctx.close();
            }
            this.isHandlingRequest = false;
        } else if (evt instanceof IdleStateEvent) {
            LOG.debug("Received IdleStateEvent.");
        } else {
            LOG.info("ClientResponseWriter Received event {}", evt);
        }
    }

    private void handleComplete(Channel channel) {
        try {
            if (this.isHandlingRequest) {
                this.completeMetrics(channel, this.zuulResponse);
                HttpRequestMessage zuulRequest = ClientRequestReceiver.getRequestFromChannel(channel);
                if (this.requestCompleteHandler != null && zuulRequest != null) {
                    this.requestCompleteHandler.handle(zuulRequest.getInboundRequest(), this.zuulResponse);
                }
            }
        }
        catch (Throwable ex) {
            LOG.error("Error in RequestCompleteHandler.", ex);
        }
    }

    protected void completeMetrics(Channel channel, HttpResponseMessage zuulResponse) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        int status = 500;
        String errorMsg = "ClientResponseWriter caught exception in client connection pipeline: " + ChannelUtils.channelInfoForLogging(ctx.channel());
        if (cause instanceof ZuulException) {
            ZuulException ze = (ZuulException)cause;
            status = ze.getStatusCode();
            LOG.error(errorMsg, cause);
        } else if (cause instanceof ReadTimeoutException) {
            LOG.error(errorMsg + ", Read timeout fired");
            status = 504;
        } else {
            LOG.error(errorMsg, cause);
        }
        if (this.isHandlingRequest && !this.startedSendingResponseToClient && ctx.channel().isActive()) {
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)status));
            ctx.writeAndFlush((Object)httpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.startedSendingResponseToClient = true;
        } else {
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        ctx.close();
    }
}

