/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.netty.common.ConnectionCloseType;
import io.netty.channel.ChannelFuture;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionsShutdown {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConnectionsShutdown.class);
    private static final DynamicBooleanProperty ENABLED = new DynamicBooleanProperty("server.outofservice.connections.shutdown", false);
    private static final DynamicIntProperty DELAY_AFTER_OUT_OF_SERVICE_MS = new DynamicIntProperty("server.outofservice.connections.delay", 2000);
    private final ChannelGroup channels;
    private final EventExecutor executor;
    private final EurekaClient discoveryClient;

    public ClientConnectionsShutdown(ChannelGroup channels, EventExecutor executor, EurekaClient discoveryClient) {
        this.channels = channels;
        this.executor = executor;
        this.discoveryClient = discoveryClient;
        if (discoveryClient != null) {
            this.initDiscoveryListener();
        }
    }

    private void initDiscoveryListener() {
        this.discoveryClient.registerEventListener(event -> {
            if (event instanceof StatusChangeEvent) {
                StatusChangeEvent sce = (StatusChangeEvent)event;
                LOG.info("Received " + sce.toString());
                if (sce.getPreviousStatus() == InstanceInfo.InstanceStatus.UP && (sce.getStatus() == InstanceInfo.InstanceStatus.OUT_OF_SERVICE || sce.getStatus() == InstanceInfo.InstanceStatus.DOWN) && ENABLED.get()) {
                    this.executor.schedule(() -> this.gracefullyShutdownClientChannels(), (long)DELAY_AFTER_OUT_OF_SERVICE_MS.get(), TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    public void gracefullyShutdownClientChannels() {
        LOG.warn("Gracefully shutting down all client channels");
        try {
            ArrayList futures = new ArrayList();
            this.channels.forEach(channel -> {
                ConnectionCloseType.setForChannel(channel, ConnectionCloseType.DELAYED_GRACEFUL);
                ChannelFuture f = channel.pipeline().close();
                futures.add(f);
            });
            LOG.warn("Waiting for " + futures.size() + " client channels to be closed.");
            for (ChannelFuture f : futures) {
                f.await();
            }
            LOG.warn(futures.size() + " client channels closed.");
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted while shutting down client channels");
        }
    }
}

