/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.netty.common.HttpClientLifecycleChannelHandler;
import com.netflix.netty.common.metrics.HttpMetricsChannelHandler;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.netty.connectionpool.ClientTimeoutHandler;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfig;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolHandler;
import com.netflix.zuul.netty.connectionpool.OriginChannelInitializer;
import com.netflix.zuul.netty.insights.PassportStateHttpClientHandler;
import com.netflix.zuul.netty.insights.PassportStateOriginHandler;
import com.netflix.zuul.netty.server.BaseZuulChannelInitializer;
import com.netflix.zuul.netty.ssl.ClientSslContextFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;

public class DefaultOriginChannelInitializer
extends OriginChannelInitializer {
    private final ConnectionPoolConfig connectionPoolConfig;
    private final SslContext sslContext;
    protected final ConnectionPoolHandler connectionPoolHandler;
    protected final HttpMetricsChannelHandler httpMetricsHandler;
    protected final LoggingHandler nettyLogger;

    public DefaultOriginChannelInitializer(ConnectionPoolConfig connPoolConfig, Registry spectatorRegistry) {
        this.connectionPoolConfig = connPoolConfig;
        String originName = this.connectionPoolConfig.getOriginName();
        this.connectionPoolHandler = new ConnectionPoolHandler(originName);
        this.httpMetricsHandler = new HttpMetricsChannelHandler(spectatorRegistry, "client", originName);
        this.nettyLogger = new LoggingHandler("zuul.origin.nettylog." + originName, LogLevel.INFO);
        this.sslContext = this.getClientSslContext(spectatorRegistry);
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new PassportStateOriginHandler()});
        if (this.connectionPoolConfig.isSecure()) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(BaseZuulChannelInitializer.MAX_INITIAL_LINE_LENGTH.get(), BaseZuulChannelInitializer.MAX_HEADER_SIZE.get(), BaseZuulChannelInitializer.MAX_CHUNK_SIZE.get(), false, false));
        pipeline.addLast("PassportStateHttpClientHandler", (ChannelHandler)new PassportStateHttpClientHandler());
        pipeline.addLast("originNettyLogger", (ChannelHandler)this.nettyLogger);
        pipeline.addLast(new ChannelHandler[]{this.httpMetricsHandler});
        this.addMethodBindingHandler(pipeline);
        pipeline.addLast("httpLifecycle", (ChannelHandler)new HttpClientLifecycleChannelHandler());
        pipeline.addLast(new ChannelHandler[]{new ClientTimeoutHandler()});
        pipeline.addLast("connectionPoolHandler", (ChannelHandler)this.connectionPoolHandler);
    }

    protected SslContext getClientSslContext(Registry spectatorRegistry) {
        return new ClientSslContextFactory(spectatorRegistry).getClientSslContext();
    }

    protected void addMethodBindingHandler(ChannelPipeline pipeline) {
    }

    @Override
    public HttpMetricsChannelHandler getHttpMetricsHandler() {
        return this.httpMetricsHandler;
    }
}

