/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpHeaderNames;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class ZuulMessageImpl
implements ZuulMessage {
    protected static final DynamicIntProperty MAX_BODY_SIZE_PROP = DynamicPropertyFactory.getInstance().getIntProperty("zuul.message.body.max.size", 25600000);
    private static final Charset CS_UTF8 = Charset.forName("UTF-8");
    protected final SessionContext context;
    protected Headers headers;
    private boolean hasBody;
    private boolean bodyBufferedCompletely;
    private List<HttpContent> bodyChunks;

    public ZuulMessageImpl(SessionContext context) {
        this(context, new Headers());
    }

    public ZuulMessageImpl(SessionContext context, Headers headers) {
        this.context = context == null ? new SessionContext() : context;
        this.headers = headers == null ? new Headers() : headers;
        this.bodyChunks = new ArrayList<HttpContent>(16);
    }

    @Override
    public SessionContext getContext() {
        return this.context;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Headers newHeaders) {
        this.headers = newHeaders;
    }

    @Override
    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    @Override
    public void setHasBody(boolean hasBody) {
        this.hasBody = hasBody;
    }

    @Override
    public boolean hasBody() {
        return this.hasBody;
    }

    @Override
    public boolean hasCompleteBody() {
        return this.bodyBufferedCompletely;
    }

    @Override
    public void bufferBodyContents(HttpContent chunk) {
        this.setHasBody(true);
        this.bodyChunks.add(chunk);
        if (chunk instanceof LastHttpContent) {
            this.bodyBufferedCompletely = true;
        }
    }

    private void setContentLength(int length) {
        this.headers.remove(HttpHeaderNames.TRANSFER_ENCODING);
        this.headers.set(HttpHeaderNames.CONTENT_LENGTH, Integer.toString(length));
    }

    @Override
    public void setBodyAsText(String bodyText) {
        this.disposeBufferedBody();
        if (!Strings.isNullOrEmpty((String)bodyText)) {
            ByteBuf content = Unpooled.copiedBuffer((byte[])bodyText.getBytes(Charsets.UTF_8));
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent(content));
            this.setContentLength(bodyText.getBytes(CS_UTF8).length);
        } else {
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            this.setContentLength(0);
        }
    }

    @Override
    public void setBody(byte[] body) {
        this.disposeBufferedBody();
        if (body != null && body.length > 0) {
            ByteBuf content = Unpooled.copiedBuffer((byte[])body);
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent(content));
            this.setContentLength(body.length);
        } else {
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            this.setContentLength(0);
        }
    }

    @Override
    public String getBodyAsText() {
        byte[] body = this.getBody();
        return body != null && body.length > 0 ? new String(this.getBody(), Charsets.UTF_8) : null;
    }

    @Override
    public byte[] getBody() {
        if (this.bodyChunks.size() == 0) {
            return null;
        }
        int size = 0;
        for (HttpContent chunk : this.bodyChunks) {
            size += chunk.content().readableBytes();
        }
        byte[] body = new byte[size];
        int offset = 0;
        for (HttpContent chunk : this.bodyChunks) {
            ByteBuf content = chunk.content();
            int len = content.readableBytes();
            content.getBytes(content.readerIndex(), body, offset, len);
            offset += len;
        }
        return body;
    }

    @Override
    public int getBodyLength() {
        int size = 0;
        for (HttpContent chunk : this.bodyChunks) {
            size += chunk.content().readableBytes();
        }
        return size;
    }

    @Override
    public Iterable<HttpContent> getBodyContents() {
        return Collections.unmodifiableList(this.bodyChunks);
    }

    @Override
    public boolean finishBufferedBodyIfIncomplete() {
        if (!this.bodyBufferedCompletely) {
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            return true;
        }
        return false;
    }

    @Override
    public void disposeBufferedBody() {
        this.bodyChunks.forEach(chunk -> {
            if (chunk != null && chunk.refCnt() > 0) {
                chunk.release();
            }
        });
        this.bodyChunks.clear();
    }

    @Override
    public void runBufferedBodyContentThroughFilter(ZuulFilter filter) {
        for (int i = 0; i < this.bodyChunks.size(); ++i) {
            HttpContent origChunk = this.bodyChunks.get(i);
            HttpContent filteredChunk = filter.processContentChunk(this, origChunk);
            if (filteredChunk == null || filteredChunk == origChunk) continue;
            this.bodyChunks.set(i, filteredChunk);
            int refCnt = origChunk.refCnt();
            if (refCnt <= 0) continue;
            origChunk.release(refCnt);
        }
    }

    @Override
    public ZuulMessage clone() {
        ZuulMessageImpl copy = new ZuulMessageImpl(this.context.clone(), this.headers.clone());
        this.bodyChunks.forEach(chunk -> {
            chunk.retain();
            copy.bufferBodyContents((HttpContent)chunk);
        });
        return copy;
    }

    @Override
    public String getInfoForLogging() {
        return "ZuulMessage";
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testClone() {
            SessionContext ctx1 = new SessionContext();
            ctx1.set("k1", "v1");
            Headers headers1 = new Headers();
            headers1.set("k1", "v1");
            ZuulMessageImpl msg1 = new ZuulMessageImpl(ctx1, headers1);
            ZuulMessage msg2 = msg1.clone();
            Assert.assertEquals((Object)msg1.getBodyAsText(), (Object)msg2.getBodyAsText());
            Assert.assertEquals((Object)msg1.getHeaders(), (Object)msg2.getHeaders());
            Assert.assertEquals((Object)msg1.getContext(), (Object)msg2.getContext());
            msg1.getHeaders().set("k1", "v_new");
            msg1.getContext().set("k1", "v_new");
            Assert.assertEquals((Object)"v1", (Object)msg2.getHeaders().getFirst("k1"));
            Assert.assertEquals((Object)"v1", msg2.getContext().get("k1"));
        }

        @Test
        public void testBufferBody2GetBody() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.bufferBodyContents((HttpContent)new DefaultHttpContent(Unpooled.copiedBuffer((byte[])"Hello ".getBytes())));
            msg.bufferBodyContents((HttpContent)new DefaultLastHttpContent(Unpooled.copiedBuffer((byte[])"World!".getBytes())));
            String body = new String(msg.getBody());
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
        }

        @Test
        public void testBufferBody3GetBody() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.bufferBodyContents((HttpContent)new DefaultHttpContent(Unpooled.copiedBuffer((byte[])"Hello ".getBytes())));
            msg.bufferBodyContents((HttpContent)new DefaultHttpContent(Unpooled.copiedBuffer((byte[])"World!".getBytes())));
            msg.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            String body = new String(msg.getBody());
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
        }

        @Test
        public void testBufferBody3GetBodyAsText() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.bufferBodyContents((HttpContent)new DefaultHttpContent(Unpooled.copiedBuffer((byte[])"Hello ".getBytes())));
            msg.bufferBodyContents((HttpContent)new DefaultHttpContent(Unpooled.copiedBuffer((byte[])"World!".getBytes())));
            msg.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            String body = msg.getBodyAsText();
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
        }

        @Test
        public void testSetBodyGetBody() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.setBody("Hello World!".getBytes());
            String body = new String(msg.getBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
        }

        @Test
        public void testSetBodyAsTextGetBody() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.setBodyAsText("Hello World!");
            String body = new String(msg.getBody());
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
        }

        @Test
        public void testSetBodyAsTextGetBodyAsText() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.setBodyAsText("Hello World!");
            String body = msg.getBodyAsText();
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
        }

        @Test
        public void testMultiSetBodyAsTextGetBody() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.setBodyAsText("Hello World!");
            String body = new String(msg.getBody());
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
            msg.setBodyAsText("Goodbye World!");
            body = new String(msg.getBody());
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Goodbye World!", (Object)body);
        }

        @Test
        public void testMultiSetBodyGetBody() {
            ZuulMessageImpl msg = new ZuulMessageImpl(new SessionContext(), new Headers());
            msg.setBody("Hello World!".getBytes());
            String body = new String(msg.getBody());
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Hello World!", (Object)body);
            msg.setBody("Goodbye World!".getBytes());
            body = new String(msg.getBody());
            Assert.assertTrue((boolean)msg.hasBody());
            Assert.assertTrue((boolean)msg.hasCompleteBody());
            Assert.assertEquals((Object)"Goodbye World!", (Object)body);
        }
    }
}

