/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters.http;

import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.zuul.filters.Endpoint;
import com.netflix.zuul.filters.SyncZuulFilter;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import rx.Observable;
import rx.Subscriber;

public abstract class HttpSyncEndpoint
extends Endpoint<HttpRequestMessage, HttpResponseMessage>
implements SyncZuulFilter<HttpRequestMessage, HttpResponseMessage> {
    private static final CachedDynamicBooleanProperty WAIT_FOR_LASTCONTENT = new CachedDynamicBooleanProperty("zuul.endpoint.sync.wait_for_lastcontent", true);
    private static final String KEY_FOR_SUBSCRIBER = "_HttpSyncEndpoint_subscriber";

    @Override
    public HttpResponseMessage getDefaultOutput(HttpRequestMessage request) {
        return HttpResponseMessageImpl.defaultErrorResponse(request);
    }

    @Override
    public Observable<HttpResponseMessage> applyAsync(HttpRequestMessage input) {
        if (WAIT_FOR_LASTCONTENT.get() && !input.hasCompleteBody()) {
            return Observable.create(subscriber -> {
                Object response = this.apply(input);
                ResponseState state = new ResponseState((ZuulMessage)response, (Subscriber)subscriber);
                input.getContext().set(KEY_FOR_SUBSCRIBER, state);
            });
        }
        return Observable.just(this.apply(input));
    }

    @Override
    public HttpContent processContentChunk(ZuulMessage zuulMessage, HttpContent chunk) {
        ResponseState state;
        if (chunk instanceof LastHttpContent && (state = (ResponseState)zuulMessage.getContext().get(KEY_FOR_SUBSCRIBER)) != null) {
            state.subscriber.onNext((Object)state.response);
            state.subscriber.onCompleted();
            zuulMessage.getContext().remove(KEY_FOR_SUBSCRIBER);
        }
        return super.processContentChunk(zuulMessage, chunk);
    }

    @Override
    public void incrementConcurrency() {
    }

    @Override
    public void decrementConcurrency() {
    }

    private static class ResponseState {
        final ZuulMessage response;
        final Subscriber subscriber;

        public ResponseState(ZuulMessage response, Subscriber subscriber) {
            this.response = response;
            this.subscriber = subscriber;
        }
    }
}

