/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.zuul.DefaultFilterFactory;
import com.netflix.zuul.DynamicCodeCompiler;
import com.netflix.zuul.FilterFactory;
import com.netflix.zuul.filters.BaseFilter;
import com.netflix.zuul.filters.BaseSyncFilter;
import com.netflix.zuul.filters.FilterRegistry;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.groovy.GroovyCompiler;
import com.netflix.zuul.message.ZuulMessage;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FilterLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FilterLoader.class);
    private final ConcurrentHashMap<String, Long> filterClassLastModified = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> filterClassCode = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> filterCheck = new ConcurrentHashMap();
    private final ConcurrentHashMap<FilterType, List<ZuulFilter>> hashFiltersByType = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ZuulFilter> filtersByNameAndType = new ConcurrentHashMap();
    private final FilterRegistry filterRegistry;
    private final DynamicCodeCompiler compiler;
    private final FilterFactory filterFactory;

    public FilterLoader() {
        this(new FilterRegistry(), new GroovyCompiler(), new DefaultFilterFactory());
    }

    @Inject
    public FilterLoader(FilterRegistry filterRegistry, DynamicCodeCompiler compiler, FilterFactory filterFactory) {
        this.filterRegistry = filterRegistry;
        this.compiler = compiler;
        this.filterFactory = filterFactory;
    }

    public ZuulFilter getFilter(String sCode, String sName) throws Exception {
        Class clazz;
        ZuulFilter filter;
        if (this.filterCheck.get(sName) == null) {
            this.filterCheck.putIfAbsent(sName, sName);
            if (!sCode.equals(this.filterClassCode.get(sName))) {
                LOG.info("reloading code " + sName);
                this.filterRegistry.remove(sName);
            }
        }
        if ((filter = this.filterRegistry.get(sName)) == null && !Modifier.isAbstract((clazz = this.compiler.compile(sCode, sName)).getModifiers())) {
            filter = this.filterFactory.newInstance(clazz);
        }
        return filter;
    }

    public int filterInstanceMapSize() {
        return this.filterRegistry.size();
    }

    public boolean putFilter(File file) throws Exception {
        try {
            Class clazz;
            ZuulFilter filter;
            String sName = file.getAbsolutePath();
            if (this.filterClassLastModified.get(sName) != null && file.lastModified() != this.filterClassLastModified.get(sName).longValue()) {
                LOG.debug("reloading filter " + sName);
                this.filterRegistry.remove(sName);
            }
            if ((filter = this.filterRegistry.get(sName)) == null && !Modifier.isAbstract((clazz = this.compiler.compile(file)).getModifiers())) {
                filter = this.filterFactory.newInstance(clazz);
                this.putFilter(sName, filter, file.lastModified());
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Error loading filter! Continuing. file=" + String.valueOf(file), (Throwable)e);
            return false;
        }
        return false;
    }

    void putFilter(String sName, ZuulFilter filter, long lastModified) {
        List<ZuulFilter> list = this.hashFiltersByType.get((Object)filter.filterType());
        if (list != null) {
            this.hashFiltersByType.remove((Object)filter.filterType());
        }
        String nameAndType = (Object)((Object)filter.filterType()) + ":" + filter.filterName();
        this.filtersByNameAndType.put(nameAndType, filter);
        this.filterRegistry.put(sName, filter);
        this.filterClassLastModified.put(sName, lastModified);
    }

    public List<ZuulFilter> putFiltersForClasses(String[] classNames) throws Exception {
        ArrayList<ZuulFilter> newFilters = new ArrayList<ZuulFilter>();
        for (String className : classNames) {
            newFilters.add(this.putFilterForClassName(className));
        }
        return newFilters;
    }

    public ZuulFilter putFilterForClassName(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        if (!ZuulFilter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Specified filter class does not implement ZuulFilter interface!");
        }
        ZuulFilter filter = this.filterFactory.newInstance(clazz);
        this.putFilter(className, filter, System.currentTimeMillis());
        return filter;
    }

    public List<ZuulFilter> getFiltersByType(FilterType filterType) {
        List<ZuulFilter> list = this.hashFiltersByType.get((Object)filterType);
        if (list != null) {
            return list;
        }
        list = new ArrayList<ZuulFilter>();
        Collection<ZuulFilter> filters = this.filterRegistry.getAllFilters();
        for (ZuulFilter filter : filters) {
            if (!filter.filterType().equals((Object)filterType)) continue;
            list.add(filter);
        }
        Collections.sort(list, new Comparator<ZuulFilter>(){

            @Override
            public int compare(ZuulFilter o1, ZuulFilter o2) {
                return o1.filterOrder() - o2.filterOrder();
            }
        });
        this.hashFiltersByType.putIfAbsent(filterType, list);
        return list;
    }

    public ZuulFilter getFilterByNameAndType(String name, FilterType type) {
        if (name == null || type == null) {
            return null;
        }
        String nameAndType = type.toString() + ":" + name;
        return this.filtersByNameAndType.get(nameAndType);
    }

    public static class UnitTest {
        @Mock
        File file;
        @Mock
        DynamicCodeCompiler compiler;
        @Mock
        FilterRegistry registry;
        FilterFactory filterFactory = new DefaultFilterFactory();
        FilterLoader loader;
        TestZuulFilter filter = new TestZuulFilter();

        @Before
        public void before() throws Exception {
            MockitoAnnotations.initMocks((Object)this);
            this.loader = (FilterLoader)Mockito.spy((Object)new FilterLoader(this.registry, this.compiler, this.filterFactory));
            ((DynamicCodeCompiler)Mockito.doReturn(TestZuulFilter.class).when((Object)this.compiler)).compile(this.file);
            Mockito.when((Object)this.file.getAbsolutePath()).thenReturn((Object)"/filters/in/SomeFilter.groovy");
        }

        @Test
        public void testGetFilterFromFile() throws Exception {
            Assert.assertTrue((boolean)this.loader.putFilter(this.file));
            ((FilterRegistry)Mockito.verify((Object)this.registry)).put((String)Matchers.any(String.class), (ZuulFilter)Matchers.any(BaseFilter.class));
        }

        @Test
        public void testPutFiltersForClasses() throws Exception {
            this.loader.putFiltersForClasses(new String[]{TestZuulFilter.class.getName()});
            ((FilterRegistry)Mockito.verify((Object)this.registry)).put((String)Matchers.any(String.class), (ZuulFilter)Matchers.any(BaseFilter.class));
        }

        @Test
        public void testPutFiltersForClassesException() throws Exception {
            ClassNotFoundException caught = null;
            try {
                this.loader.putFiltersForClasses(new String[]{"asdf"});
            }
            catch (ClassNotFoundException e) {
                caught = e;
            }
            Assert.assertTrue((caught != null ? 1 : 0) != 0);
            ((FilterRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)0))).put((String)Matchers.any(String.class), (ZuulFilter)Matchers.any(BaseFilter.class));
        }

        @Test
        public void testGetFiltersByType() throws Exception {
            Assert.assertTrue((boolean)this.loader.putFilter(this.file));
            ((FilterRegistry)Mockito.verify((Object)this.registry)).put((String)Matchers.any(String.class), (ZuulFilter)Matchers.any(ZuulFilter.class));
            ArrayList<TestZuulFilter> filters = new ArrayList<TestZuulFilter>();
            filters.add(this.filter);
            Mockito.when(this.registry.getAllFilters()).thenReturn(filters);
            List<ZuulFilter> list = this.loader.getFiltersByType(FilterType.INBOUND);
            Assert.assertTrue((list != null ? 1 : 0) != 0);
            Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            ZuulFilter filter = list.get(0);
            Assert.assertTrue((filter != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)filter.filterType().equals((Object)FilterType.INBOUND));
        }

        @Test
        public void testGetFilterFromString() throws Exception {
            String string = "";
            ((DynamicCodeCompiler)Mockito.doReturn(TestZuulFilter.class).when((Object)this.compiler)).compile(string, string);
            ZuulFilter filter = this.loader.getFilter(string, string);
            Assert.assertNotNull((Object)filter);
            Assert.assertTrue((filter.getClass() == TestZuulFilter.class ? 1 : 0) != 0);
        }
    }

    public static class TestZuulFilter
    extends BaseSyncFilter {
        @Override
        public FilterType filterType() {
            return FilterType.INBOUND;
        }

        @Override
        public int filterOrder() {
            return 0;
        }

        @Override
        public boolean shouldFilter(ZuulMessage msg) {
            return false;
        }

        @Override
        public ZuulMessage apply(ZuulMessage msg) {
            return null;
        }
    }
}

