/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.proxyprotocol;

import com.netflix.config.CachedDynamicBooleanProperty;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.ProtocolDetectionResult;
import io.netty.handler.codec.ProtocolDetectionState;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalHAProxyMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "OptionalHAProxyMessageDecoder";
    private static final Logger logger = LoggerFactory.getLogger((String)"OptionalHAProxyMessageDecoder");
    private static final CachedDynamicBooleanProperty dumpHAProxyByteBuf = new CachedDynamicBooleanProperty("zuul.haproxy.dump.bytebuf", false);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block5: {
            if (msg instanceof ByteBuf) {
                try {
                    ProtocolDetectionResult result = HAProxyMessageDecoder.detectProtocol((ByteBuf)((ByteBuf)msg));
                    if (result.state() == ProtocolDetectionState.DETECTED) {
                        ctx.pipeline().addAfter(NAME, null, (ChannelHandler)new HAProxyMessageDecoder());
                        ctx.pipeline().remove((ChannelHandler)this);
                    }
                }
                catch (Exception e) {
                    if (msg == null) break block5;
                    logger.error("Exception in OptionalHAProxyMessageDecoder {}" + e.getClass().getCanonicalName());
                    if (dumpHAProxyByteBuf.get()) {
                        logger.error("Exception Stack: {}" + e.getStackTrace());
                        logger.error("Bytebuf is:  {} " + ((ByteBuf)msg).toString(CharsetUtil.US_ASCII));
                    }
                    ((ByteBuf)msg).release();
                }
            }
        }
        super.channelRead(ctx, msg);
    }
}

