/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicGauge;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ServerChannelMetrics
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ServerChannelMetrics.class);
    private static final AttributeKey<AtomicInteger> ATTR_CURRENT_CONNS = AttributeKey.newInstance((String)"_server_connections_count");
    private final Gauge currentConnectionsGauge;
    private final AtomicInteger currentConnections = new AtomicInteger(0);
    private final BasicCounter totalConnections;
    private final BasicCounter connectionClosed;
    private final BasicCounter connectionIdleTimeout;
    private final BasicCounter connectionErrors;
    private final BasicCounter connectionThrottled;

    public ServerChannelMetrics(String id) {
        String metricNamePrefix = "server.connections.";
        this.currentConnectionsGauge = new BasicGauge(MonitorConfig.builder((String)(metricNamePrefix + "current")).withTag("id", id).build(), () -> this.currentConnections.get());
        DefaultMonitorRegistry.getInstance().register((Monitor)this.currentConnectionsGauge);
        this.totalConnections = ServerChannelMetrics.createCounter(metricNamePrefix + "connect", id);
        this.connectionErrors = ServerChannelMetrics.createCounter(metricNamePrefix + "errors", id);
        this.connectionClosed = ServerChannelMetrics.createCounter(metricNamePrefix + "close", id);
        this.connectionIdleTimeout = ServerChannelMetrics.createCounter(metricNamePrefix + "idle.timeout", id);
        this.connectionThrottled = ServerChannelMetrics.createCounter(metricNamePrefix + "throttled", id);
    }

    private static BasicCounter createCounter(String name, String id) {
        BasicCounter counter = new BasicCounter(MonitorConfig.builder((String)name).withTag("id", id).build());
        DefaultMonitorRegistry.getInstance().register((Monitor)counter);
        return counter;
    }

    public static int currentConnectionCountFromChannel(Channel ch) {
        AtomicInteger count = (AtomicInteger)ch.attr(ATTR_CURRENT_CONNS).get();
        return count == null ? 0 : count.get();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.currentConnections.incrementAndGet();
        this.totalConnections.increment();
        ctx.channel().attr(ATTR_CURRENT_CONNS).set((Object)this.currentConnections);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelInactive(ctx);
        }
        finally {
            this.currentConnections.decrementAndGet();
            this.connectionClosed.increment();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.connectionErrors.increment();
        if (LOG.isInfoEnabled()) {
            LOG.info("Connection error caught. " + String.valueOf(cause), cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == "connection_throttled") {
            this.connectionThrottled.increment();
        } else if (evt instanceof IdleStateEvent) {
            this.connectionIdleTimeout.increment();
        }
        super.userEventTriggered(ctx, evt);
    }
}

