/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.netty.common.ConnectionCloseType;
import com.netflix.netty.common.HttpChannelFlags;
import com.netflix.spectator.api.Registry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Http2ConnectionCloseHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ConnectionCloseHandler.class);
    private static final DynamicBooleanProperty ALLOW_GRACEFUL_DELAYED = new DynamicBooleanProperty("server.connection.close.graceful.delayed.allow", true);
    private static final DynamicBooleanProperty SWALLOW_UNKNOWN_EXCEPTIONS_ON_CONN_CLOSE = new DynamicBooleanProperty("server.connection.close.swallow.unknown.exceptions", false);
    private static final SwallowHttp2ExceptionShutdownHint SWALLOW_EXCEPTION_HANDLER = new SwallowHttp2ExceptionShutdownHint();
    private final int gracefulCloseDelay;
    protected static Registry registry;

    public Http2ConnectionCloseHandler(int gracefulCloseDelay, Registry registry) {
        this.gracefulCloseDelay = gracefulCloseDelay;
        Http2ConnectionCloseHandler.registry = registry;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        String handlerName;
        ChannelPipeline parentPipeline = ctx.channel().parent().pipeline();
        if (parentPipeline.get(handlerName = "h2_exception_swallow_handler") == null) {
            parentPipeline.addLast(handlerName, (ChannelHandler)SWALLOW_EXCEPTION_HANDLER);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        super.write(ctx, msg, promise);
        if (this.isEndOfRequestResponse(msg) && HttpChannelFlags.CLOSE_AFTER_RESPONSE.get(ctx)) {
            promise.addListener(future -> {
                Channel parent = this.parentChannel(ctx);
                this.closeChannel(ctx, parent, ConnectionCloseType.fromChannel(ctx.channel()), ctx.newPromise());
            });
        }
    }

    protected boolean isEndOfRequestResponse(Object msg) {
        if (msg instanceof Http2HeadersFrame) {
            return ((Http2HeadersFrame)msg).isEndStream();
        }
        if (msg instanceof Http2DataFrame) {
            return ((Http2DataFrame)msg).isEndStream();
        }
        return false;
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        Channel parent = this.parentChannel(ctx);
        ConnectionCloseType type = ConnectionCloseType.fromChannel(parent);
        this.closeChannel(ctx, parent, type, promise);
    }

    protected void closeChannel(ChannelHandlerContext ctx, Channel channel, ConnectionCloseType evt, ChannelPromise promise) {
        switch (evt) {
            case DELAYED_GRACEFUL: {
                this.gracefullyWithDelay(ctx, channel, promise);
                break;
            }
            case GRACEFUL: {
                this.gracefully(channel, promise);
                break;
            }
            case IMMEDIATE: {
                this.immediately(channel, promise);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ConnectionCloseEvent type! - " + String.valueOf((Object)evt));
            }
        }
    }

    protected void gracefullyWithDelay(ChannelHandlerContext ctx, Channel channel, ChannelPromise promise) {
        if (!ALLOW_GRACEFUL_DELAYED.get()) {
            this.gracefully(channel, promise);
            return;
        }
        if (this.isAlreadyClosing(channel)) {
            promise.setSuccess();
            return;
        }
        DefaultHttp2GoAwayFrame goaway = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
        goaway.setExtraStreamIds(Integer.MAX_VALUE);
        channel.writeAndFlush((Object)goaway);
        LOG.debug("gracefullyWithDelay: flushed initial go_away frame. channel=" + channel.id().asShortText());
        ctx.executor().schedule(() -> {
            this.gracefulConnectionShutdown(channel);
            promise.setSuccess();
        }, (long)this.gracefulCloseDelay, TimeUnit.SECONDS);
    }

    protected void gracefulConnectionShutdown(Channel channel) {
        if (channel.isActive()) {
            LOG.debug("gracefullyWithDelay: firing graceful_shutdown event to make netty send a final go_away frame and then close connection. channel=" + channel.id().asShortText());
            Http2Exception h2e = new Http2Exception(Http2Error.NO_ERROR, Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN);
            channel.pipeline().fireExceptionCaught((Throwable)h2e);
        } else {
            LOG.debug("gracefullyWithDelay: connection already closed, so no need to send final go_away frame. channel=" + channel.id().asShortText());
        }
    }

    protected void gracefully(Channel channel, ChannelPromise promise) {
        if (this.isAlreadyClosing(channel)) {
            promise.setSuccess();
            return;
        }
        this.gracefulConnectionShutdown(channel);
        promise.setSuccess();
    }

    protected void immediately(Channel parent, ChannelPromise promise) {
        if (this.isAlreadyClosing(parent)) {
            promise.setSuccess();
            return;
        }
        if (parent.isActive()) {
            parent.close(promise);
        } else {
            promise.setSuccess();
        }
    }

    protected boolean isAlreadyClosing(Channel parentChannel) {
        if (HttpChannelFlags.CLOSING.get(parentChannel)) {
            return true;
        }
        HttpChannelFlags.CLOSING.set(parentChannel);
        return false;
    }

    protected Channel parentChannel(ChannelHandlerContext ctx) {
        return ctx.channel().parent();
    }

    protected static void incrementExceptionCounter(Throwable throwable) {
        registry.counter("server.connection.exception", new String[]{"handler", "Http2ConnectionCloseHandler", "id", throwable.getClass().getSimpleName()}).increment();
    }

    @ChannelHandler.Sharable
    static class SwallowHttp2ExceptionShutdownHint
    extends ChannelOutboundHandlerAdapter {
        SwallowHttp2ExceptionShutdownHint() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof Http2Exception) {
                Http2Exception h2e = (Http2Exception)cause;
                if (h2e.error() != Http2Error.NO_ERROR || !Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN.equals((Object)h2e.shutdownHint())) {
                    super.exceptionCaught(ctx, cause);
                }
            } else if (cause instanceof Errors.NativeIoException) {
                LOG.debug("SwallowHttp2ExceptionShutdownHint, NativeIoException " + cause);
                Http2ConnectionCloseHandler.incrementExceptionCounter(cause);
            } else {
                LOG.debug("SwallowHttp2ExceptionShutdownHint unknown exception " + cause);
                if (!SWALLOW_UNKNOWN_EXCEPTIONS_ON_CONN_CLOSE.get()) {
                    super.exceptionCaught(ctx, cause);
                }
            }
        }
    }
}

