/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.impl;

import com.netflix.spectator.controllers.shaded.spectator-spring.json.annotation.JacksonInject;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.JsonParser;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.DatabindException;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.DeserializationContext;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.DeserializationFeature;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonDeserializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonMappingException;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.CreatorProperty;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.SettableAnyProperty;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.SettableBeanProperty;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.impl.ObjectIdReader;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.impl.PropertyValue;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.impl.ReadableObjectId;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.introspect.AnnotatedMember;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.BitSet;

public class PropertyValueBuffer {
    protected final JsonParser _parser;
    protected final DeserializationContext _context;
    protected final ObjectIdReader _objectIdReader;
    protected final Object[] _creatorParameters;
    protected int _paramsNeeded;
    protected int _paramsSeen;
    protected final BitSet _paramsSeenBig;
    protected PropertyValue _buffered;
    protected Object _idValue;
    protected final SettableAnyProperty _anyParamSetter;
    protected PropertyValue _anyParamBuffered;
    protected final BitSet _injectablePropIndexes;

    public PropertyValueBuffer(JsonParser p, DeserializationContext ctxt, int paramCount, ObjectIdReader oir, SettableAnyProperty anyParamSetter, BitSet injectablePropIndexes) {
        this._parser = p;
        this._context = ctxt;
        this._paramsNeeded = paramCount;
        this._objectIdReader = oir;
        this._creatorParameters = new Object[paramCount];
        this._paramsSeenBig = paramCount < 32 ? null : new BitSet();
        this._anyParamSetter = anyParamSetter == null || anyParamSetter.getParameterIndex() < 0 ? null : anyParamSetter;
        this._injectablePropIndexes = injectablePropIndexes == null ? null : (BitSet)injectablePropIndexes.clone();
    }

    @Deprecated
    public PropertyValueBuffer(JsonParser p, DeserializationContext ctxt, int paramCount, ObjectIdReader oir, SettableAnyProperty anyParamSetter) {
        this(p, ctxt, paramCount, oir, anyParamSetter, null);
    }

    public final boolean hasParameter(SettableBeanProperty prop) {
        int ix = prop.getCreatorIndex();
        if (this._paramsSeenBig == null ? (this._paramsSeen >> ix & 1) == 1 : this._paramsSeenBig.get(ix)) {
            return true;
        }
        return this._anyParamSetter != null && ix == this._anyParamSetter.getParameterIndex();
    }

    public Object getParameter(SettableBeanProperty prop) throws JsonMappingException {
        Object value;
        if (this.hasParameter(prop)) {
            value = this._creatorParameters[prop.getCreatorIndex()];
        } else {
            Object object = this._findMissing(prop);
            this._creatorParameters[prop.getCreatorIndex()] = object;
            value = object;
        }
        if (value == null && this._anyParamSetter != null && prop.getCreatorIndex() == this._anyParamSetter.getParameterIndex()) {
            value = this._createAndSetAnySetterValue();
        }
        if (value == null && this._context.isEnabled(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES)) {
            return this._context.reportInputMismatch(prop, "Null value for creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES` enabled", prop.getName(), prop.getCreatorIndex());
        }
        return value;
    }

    public Object[] getParameters(SettableBeanProperty[] props) throws JsonMappingException, IOException {
        int len;
        int ix;
        if (this._paramsNeeded > 0) {
            if (this._paramsSeenBig == null) {
                int mask = this._paramsSeen;
                ix = 0;
                int len2 = this._creatorParameters.length;
                while (ix < len2) {
                    if ((mask & 1) == 0) {
                        this._creatorParameters[ix] = this._findMissing(props[ix]);
                    }
                    ++ix;
                    mask >>= 1;
                }
            } else {
                len = this._creatorParameters.length;
                ix = 0;
                while ((ix = this._paramsSeenBig.nextClearBit(ix)) < len) {
                    this._creatorParameters[ix] = this._findMissing(props[ix]);
                    ++ix;
                }
            }
        }
        if (this._anyParamSetter != null) {
            this._creatorParameters[this._anyParamSetter.getParameterIndex()] = this._createAndSetAnySetterValue();
        }
        if (this._injectablePropIndexes != null) {
            int ix2 = this._injectablePropIndexes.nextSetBit(0);
            while (ix2 >= 0) {
                this._inject(props[ix2]);
                ix2 = this._injectablePropIndexes.nextSetBit(ix2 + 1);
            }
        }
        if (this._context.isEnabled(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES)) {
            len = this._creatorParameters.length;
            for (ix = 0; ix < len; ++ix) {
                if (this._creatorParameters[ix] != null) continue;
                SettableBeanProperty prop = props[ix];
                this._context.reportInputMismatch(prop, "Null value for creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES` enabled", prop.getName(), props[ix].getCreatorIndex());
            }
        }
        return this._creatorParameters;
    }

    private Object _createAndSetAnySetterValue() throws JsonMappingException {
        Object anySetterParameterObject = this._anyParamSetter.createParameterObject();
        PropertyValue pv = this._anyParamBuffered;
        while (pv != null) {
            try {
                pv.setValue(anySetterParameterObject);
            }
            catch (JsonMappingException e) {
                throw e;
            }
            catch (IOException e) {
                throw JsonMappingException.fromUnexpectedIOE(e);
            }
            pv = pv.next;
        }
        return anySetterParameterObject;
    }

    protected Object _findMissing(SettableBeanProperty prop) throws JsonMappingException {
        if (this._anyParamSetter != null && prop.getCreatorIndex() == this._anyParamSetter.getParameterIndex() && this._anyParamBuffered != null) {
            return null;
        }
        JacksonInject.Value injection = prop.getInjectionDefinition();
        if (injection != null) {
            this._injectablePropIndexes.clear(prop.getCreatorIndex());
            return this._context.findInjectableValue(prop.getInjectableValueId(), prop, null, injection.getOptional(), injection.getUseInput());
        }
        if (prop.isRequired()) {
            this._context.reportInputMismatch(prop, "Missing required creator property '%s' (index %d)", prop.getName(), prop.getCreatorIndex());
        }
        if (this._context.isEnabled(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES)) {
            this._context.reportInputMismatch(prop, "Missing creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES` enabled", prop.getName(), prop.getCreatorIndex());
        }
        try {
            Object absentValue = prop.getNullValueProvider().getAbsentValue(this._context);
            if (absentValue != null) {
                return absentValue;
            }
            JsonDeserializer<Object> deser = prop.getValueDeserializer();
            return deser.getAbsentValue(this._context);
        }
        catch (DatabindException e) {
            AnnotatedMember member = prop.getMember();
            if (member != null) {
                e.prependPath(member.getDeclaringClass(), prop.getName());
            }
            throw e;
        }
    }

    private void _inject(SettableBeanProperty prop) throws JsonMappingException {
        Object value;
        Boolean useInput;
        JacksonInject.Value injection = prop.getInjectionDefinition();
        if (injection != null && !Boolean.TRUE.equals(useInput = injection.getUseInput()) && (value = this._context.findInjectableValue(injection.getId(), prop, prop.getMember(), injection.getOptional(), useInput)) != null) {
            int ix = prop.getCreatorIndex();
            this._creatorParameters[ix] = value;
        }
    }

    public boolean readIdProperty(String propName) throws IOException {
        if (this._objectIdReader != null && propName.equals(this._objectIdReader.propertyName.getSimpleName())) {
            this._idValue = this._objectIdReader.readObjectReference(this._parser, this._context);
            return true;
        }
        return false;
    }

    public Object handleIdValue(DeserializationContext ctxt, Object bean) throws IOException {
        if (this._objectIdReader != null) {
            if (this._idValue != null) {
                ReadableObjectId roid = ctxt.findObjectId(this._idValue, this._objectIdReader.generator, this._objectIdReader.resolver);
                roid.bindItem(bean);
                SettableBeanProperty idProp = this._objectIdReader.idProperty;
                if (idProp != null) {
                    if (idProp instanceof CreatorProperty) {
                        return bean;
                    }
                    return idProp.setAndReturn(bean, this._idValue);
                }
            } else {
                ctxt.reportUnresolvedObjectId(this._objectIdReader, bean);
            }
        }
        return bean;
    }

    protected PropertyValue buffered() {
        return this._buffered;
    }

    public boolean isComplete() {
        return this._paramsNeeded <= 0;
    }

    public boolean assignParameter(SettableBeanProperty prop, Object value) {
        int ix = prop.getCreatorIndex();
        this._creatorParameters[ix] = value;
        if (this._paramsSeenBig == null) {
            int old = this._paramsSeen;
            int newValue = old | 1 << ix;
            if (old != newValue) {
                this._paramsSeen = newValue;
                if (--this._paramsNeeded <= 0) {
                    return this._objectIdReader == null || this._idValue != null;
                }
            }
        } else if (!this._paramsSeenBig.get(ix)) {
            this._paramsSeenBig.set(ix);
            if (--this._paramsNeeded <= 0) {
                return this._objectIdReader == null || this._idValue != null;
            }
        }
        return false;
    }

    public void bufferProperty(SettableBeanProperty prop, Object value) {
        this._buffered = new PropertyValue.Regular(this._buffered, value, prop);
    }

    public void bufferAnyProperty(SettableAnyProperty prop, String propName, Object value) {
        this._buffered = new PropertyValue.Any(this._buffered, value, prop, propName);
    }

    public void bufferMapProperty(Object key, Object value) {
        this._buffered = new PropertyValue.Map(this._buffered, value, key);
    }

    public void bufferAnyParameterProperty(SettableAnyProperty prop, String propName, Object value) {
        this._anyParamBuffered = new PropertyValue.AnyParameter(this._anyParamBuffered, value, prop, propName);
    }

    public void bufferMergingProperty(SettableBeanProperty prop, TokenBuffer buffered) {
        this._buffered = new PropertyValue.Merging(this._buffered, buffered, prop);
    }
}

