/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.filter;

import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.controllers.filter.PrototypeMeasurementFilterSpecification;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class PrototypeMeasurementFilter
implements Predicate<Measurement> {
    private final List<MeterFilterPattern> includePatterns = new ArrayList<MeterFilterPattern>();
    private final List<MeterFilterPattern> excludePatterns = new ArrayList<MeterFilterPattern>();
    private final Map<String, IncludeExcludePatterns> metricNameToPatterns = new HashMap<String, IncludeExcludePatterns>();

    public PrototypeMeasurementFilter(PrototypeMeasurementFilterSpecification specification) {
        for (Map.Entry<String, PrototypeMeasurementFilterSpecification.MeterFilterSpecification> entry : specification.getInclude().entrySet()) {
            this.includePatterns.add(new MeterFilterPattern(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, PrototypeMeasurementFilterSpecification.MeterFilterSpecification> entry : specification.getExclude().entrySet()) {
            this.excludePatterns.add(new MeterFilterPattern(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public boolean test(Measurement measurement) {
        IncludeExcludePatterns patterns = this.metricToPatterns(measurement.id().name());
        return patterns != null && patterns.test(measurement);
    }

    public IncludeExcludePatterns metricToPatterns(String metric) {
        IncludeExcludePatterns foundPatterns = this.metricNameToPatterns.get(metric);
        if (foundPatterns != null) {
            return foundPatterns;
        }
        foundPatterns = new IncludeExcludePatterns();
        for (MeterFilterPattern meterPattern : this.includePatterns) {
            if (!meterPattern.namePattern.matcher(metric).matches()) continue;
            foundPatterns.include.addAll(meterPattern.values);
        }
        for (MeterFilterPattern meterPattern : this.excludePatterns) {
            if (!meterPattern.namePattern.matcher(metric).matches()) continue;
            foundPatterns.exclude.addAll(meterPattern.values);
        }
        this.metricNameToPatterns.put(metric, foundPatterns);
        return foundPatterns;
    }

    public static PrototypeMeasurementFilter loadFromPath(String path) throws IOException {
        PrototypeMeasurementFilterSpecification spec = PrototypeMeasurementFilterSpecification.loadFromPath(path);
        return new PrototypeMeasurementFilter(spec);
    }

    public static class IncludeExcludePatterns {
        private final List<ValueFilterPattern> include = new ArrayList<ValueFilterPattern>();
        private final List<ValueFilterPattern> exclude = new ArrayList<ValueFilterPattern>();

        public List<ValueFilterPattern> getInclude() {
            return this.include;
        }

        public List<ValueFilterPattern> getExclude() {
            return this.exclude;
        }

        public IncludeExcludePatterns() {
        }

        public IncludeExcludePatterns(List<ValueFilterPattern> include, List<ValueFilterPattern> exclude) {
            this.include.addAll(include);
            this.exclude.addAll(exclude);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IncludeExcludePatterns)) {
                return false;
            }
            IncludeExcludePatterns other = (IncludeExcludePatterns)obj;
            return this.include.equals(other.include) && this.exclude.equals(other.exclude);
        }

        public int hashCode() {
            return Objects.hash(this.include, this.exclude);
        }

        public boolean test(Measurement measurement) {
            boolean ok = this.include.isEmpty();
            for (ValueFilterPattern pattern : this.include) {
                if (!pattern.test(measurement.id().tags())) continue;
                ok = true;
                break;
            }
            if (ok) {
                for (ValueFilterPattern pattern : this.exclude) {
                    if (!pattern.test(measurement.id().tags())) continue;
                    return false;
                }
            }
            return ok;
        }
    }

    public static class MeterFilterPattern {
        private final Pattern namePattern;
        private final List<ValueFilterPattern> values = new ArrayList<ValueFilterPattern>();

        public MeterFilterPattern(String nameRegex, PrototypeMeasurementFilterSpecification.MeterFilterSpecification spec) {
            this.namePattern = Pattern.compile(nameRegex);
            if (spec == null) {
                return;
            }
            if (spec.getValues().isEmpty()) {
                this.values.add(new ValueFilterPattern(PrototypeMeasurementFilterSpecification.ValueFilterSpecification.ALL));
            }
            for (PrototypeMeasurementFilterSpecification.ValueFilterSpecification value : spec.getValues()) {
                this.values.add(new ValueFilterPattern(value));
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MeterFilterPattern)) {
                return false;
            }
            MeterFilterPattern other = (MeterFilterPattern)obj;
            return this.namePattern.equals(other.namePattern) && this.values.equals(other.values);
        }

        public int hashCode() {
            return Objects.hash(this.namePattern, this.values);
        }

        public List<ValueFilterPattern> getValues() {
            return this.values;
        }
    }

    public static class ValueFilterPattern {
        private final List<TagFilterPattern> tags = new ArrayList<TagFilterPattern>();

        public ValueFilterPattern(PrototypeMeasurementFilterSpecification.ValueFilterSpecification spec) {
            if (spec == null) {
                return;
            }
            for (PrototypeMeasurementFilterSpecification.TagFilterSpecification tag : spec.getTags()) {
                this.tags.add(new TagFilterPattern(tag));
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ValueFilterPattern)) {
                return false;
            }
            ValueFilterPattern other = (ValueFilterPattern)obj;
            return this.tags.equals(other.tags);
        }

        public int hashCode() {
            return this.tags.hashCode();
        }

        static boolean patternInList(TagFilterPattern tagPattern, Iterable<Tag> sourceTags) {
            for (Tag candidateTag : sourceTags) {
                if (!tagPattern.test(candidateTag)) continue;
                return true;
            }
            return false;
        }

        public boolean test(Iterable<Tag> sourceTags) {
            for (TagFilterPattern tagPattern : this.tags) {
                if (ValueFilterPattern.patternInList(tagPattern, sourceTags)) continue;
                return false;
            }
            return true;
        }

        public List<TagFilterPattern> getTags() {
            return this.tags;
        }
    }

    public static class TagFilterPattern {
        private Pattern key;
        private Pattern value;

        public TagFilterPattern(Pattern key, Pattern value) {
            this.key = key;
            this.value = value;
        }

        public TagFilterPattern(PrototypeMeasurementFilterSpecification.TagFilterSpecification spec) {
            if (spec == null) {
                return;
            }
            String keySpec = spec.getKey();
            String valueSpec = spec.getValue();
            if (keySpec != null && !keySpec.isEmpty() && !".*".equals(keySpec)) {
                this.key = Pattern.compile(keySpec);
            }
            if (valueSpec != null && !valueSpec.isEmpty() && !".*".equals(valueSpec)) {
                this.value = Pattern.compile(valueSpec);
            }
        }

        public int hashCode() {
            return Objects.hash(this.key.pattern(), this.value.pattern());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagFilterPattern)) {
                return false;
            }
            TagFilterPattern other = (TagFilterPattern)obj;
            return this.key.pattern().equals(other.key.pattern()) && this.value.pattern().equals(other.value.pattern());
        }

        public boolean test(Tag tag) {
            if (this.key != null && !this.key.matcher(tag.key()).matches()) {
                return false;
            }
            return this.value == null || this.value.matcher(tag.value()).matches();
        }

        public String toString() {
            return String.format("%s=%s", this.key.pattern(), this.value.pattern());
        }
    }
}

