/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.std;

import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.JsonParser;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.JsonToken;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.DeserializationContext;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonMappingException;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.deser.std.StdScalarDeserializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.type.LogicalType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (t == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        Boolean b = this._parseBoolean(p, ctxt, AtomicBoolean.class);
        return b == null ? null : new AtomicBoolean(b);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicBoolean(false);
    }
}

