/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.std;

import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.JsonGenerator;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.BeanProperty;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JavaType;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonMappingException;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonNode;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.SerializerProvider;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonschema.SchemaAware;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsontype.TypeSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.ContextualSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.ResolvableSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.std.StdSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.util.ClassUtil;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.util.Converter;
import java.io.IOException;
import java.lang.reflect.Type;

public class StdDelegatingSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable {
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final JsonSerializer<Object> _delegateSerializer;

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public <T> StdDelegatingSerializer(Class<T> cls, Converter<T, ?> converter) {
        super(cls, false);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
        super(delegateType);
        this._converter = converter;
        this._delegateType = delegateType;
        this._delegateSerializer = delegateSerializer;
    }

    protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
        ClassUtil.verifyMustOverride(StdDelegatingSerializer.class, this, "withDelegate");
        return new StdDelegatingSerializer(converter, delegateType, delegateSerializer);
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._delegateSerializer != null && this._delegateSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this._delegateSerializer)).resolve(provider);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> delSer = this._delegateSerializer;
        JavaType delegateType = this._delegateType;
        if (delSer == null) {
            if (delegateType == null) {
                delegateType = this._converter.getOutputType(provider.getTypeFactory());
            }
            if (!delegateType.isJavaLangObject()) {
                delSer = provider.findValueSerializer(delegateType);
            }
        }
        if (delSer instanceof ContextualSerializer) {
            delSer = provider.handleSecondaryContextualization(delSer, property);
        }
        if (delSer == this._delegateSerializer && delegateType == this._delegateType) {
            return this;
        }
        return this.withDelegate(this._converter, delegateType, delSer);
    }

    protected Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public JsonSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Object delegateValue = this.convertValue(value);
        if (delegateValue == null) {
            provider.defaultSerializeNull(gen);
            return;
        }
        JsonSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(delegateValue, provider);
        }
        ser.serialize(delegateValue, gen, provider);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        Object delegateValue = this.convertValue(value);
        if (delegateValue == null) {
            provider.defaultSerializeNull(gen);
            return;
        }
        JsonSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(value, provider);
        }
        ser.serializeWithType(delegateValue, gen, provider, typeSer);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        Object delegateValue = this.convertValue(value);
        if (delegateValue == null) {
            return true;
        }
        if (this._delegateSerializer == null) {
            return value == null;
        }
        return this._delegateSerializer.isEmpty(prov, delegateValue);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(provider, typeHint);
        }
        return super.getSchema(provider, typeHint);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint, boolean isOptional) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(provider, typeHint, isOptional);
        }
        return super.getSchema(provider, typeHint);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._delegateSerializer != null) {
            this._delegateSerializer.acceptJsonFormatVisitor(visitor, typeHint);
        }
    }

    protected Object convertValue(Object value) {
        return this._converter.convert(value);
    }

    protected JsonSerializer<Object> _findSerializer(Object value, SerializerProvider serializers) throws JsonMappingException {
        return serializers.findValueSerializer(value.getClass());
    }
}

