/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.std;

import com.netflix.spectator.controllers.shaded.spectator-spring.json.annotation.JsonFormat;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.JsonGenerator;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.AnnotationIntrospector;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.BeanProperty;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JavaType;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonMappingException;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonNode;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.SerializerProvider;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.introspect.AnnotatedMember;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsontype.TypeSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.ContextualSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.std.CollectionSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T>
implements ContextualSerializer {
    protected final Boolean _unwrapSingle;

    protected StaticListSerializerBase(Class<?> cls) {
        super(cls, false);
        this._unwrapSingle = null;
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> src, Boolean unwrapSingle) {
        super(src);
        this._unwrapSingle = unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        JsonSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            Object serDef;
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null && (serDef = intr.findContentSerializer(m)) != null) {
                ser = serializers.serializerInstance(m, serDef);
            }
        }
        if ((format = this.findFormatOverrides(serializers, property, this.handledType())) != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((ser = this.findContextualConvertingSerializer(serializers, property, ser)) == null) {
            ser = serializers.findContentValueSerializer(String.class, property);
        }
        if (this.isDefaultSerializer(ser)) {
            if (Objects.equals(unwrapSingle, this._unwrapSingle)) {
                return this;
            }
            return this._withResolved(property, unwrapSingle);
        }
        return new CollectionSerializer(serializers.constructType((Type)((Object)String.class)), true, null, ser);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null || value.isEmpty();
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.contentSchema());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            this.acceptContentVisitor(v2);
        }
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1) throws JsonMappingException;

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializerProvider var3, TypeSerializer var4) throws IOException;
}

