/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.controllers.filter.PrototypeMeasurementFilter;
import com.netflix.spectator.controllers.filter.TagMeasurementFilter;
import com.netflix.spectator.controllers.model.ApplicationRegistry;
import com.netflix.spectator.controllers.model.MetricValues;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/spectator/metrics"})
@RestController
@ConditionalOnExpression(value="${spectator.webEndpoint.enabled:false}")
public class MetricsController {
    @Autowired
    private Registry registry;
    public static final Predicate<Measurement> ALL_MEASUREMENTS_FILTER = m -> true;
    @Value(value="${spectator.applicationName:}")
    private String applicationName;
    @Value(value="${spectator.applicationVersion:}")
    private String applicationVersion;
    @Value(value="${spectator.webEndpoint.prototypeFilter.path:}")
    private String prototypeFilterPath;
    private Map<Id, String> knownMeterKinds = new HashMap<Id, String>();
    private Predicate<Measurement> defaultMeasurementFilter = null;

    public Predicate<Measurement> getDefaultMeasurementFilter() throws IOException {
        if (this.defaultMeasurementFilter != null) {
            return this.defaultMeasurementFilter;
        }
        this.defaultMeasurementFilter = !this.prototypeFilterPath.isEmpty() ? PrototypeMeasurementFilter.loadFromPath(this.prototypeFilterPath) : ALL_MEASUREMENTS_FILTER;
        return this.defaultMeasurementFilter;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ApplicationRegistry getMetrics(@RequestParam Map<String, String> filters) throws IOException {
        boolean all = filters.get("all") != null;
        String filterMeterNameRegex = filters.getOrDefault("meterNameRegex", "");
        String filterTagNameRegex = filters.getOrDefault("tagNameRegex", "");
        String filterTagValueRegex = filters.getOrDefault("tagValueRegex", "");
        TagMeasurementFilter queryFilter = new TagMeasurementFilter(filterMeterNameRegex, filterTagNameRegex, filterTagValueRegex);
        Predicate<Measurement> filter = all ? queryFilter : queryFilter.and(this.getDefaultMeasurementFilter());
        ApplicationRegistry response = new ApplicationRegistry();
        response.setApplicationName(this.applicationName);
        response.setApplicationVersion(this.applicationVersion);
        response.setMetrics(this.encodeRegistry(this.registry, filter));
        return response;
    }

    Map<String, MetricValues> encodeRegistry(Registry sourceRegistry, Predicate<Measurement> filter) {
        HashMap<String, MetricValues> metricMap = new HashMap<String, MetricValues>();
        for (Meter meter : sourceRegistry) {
            String kind = this.knownMeterKinds.computeIfAbsent(meter.id(), k -> MetricsController.meterToKind(sourceRegistry, meter));
            for (Measurement measurement : meter.measure()) {
                if (!filter.test(measurement)) continue;
                String measurementName = measurement.id().name();
                MetricValues have = (MetricValues)metricMap.get(measurementName);
                if (have == null) {
                    metricMap.put(measurementName, new MetricValues(kind, measurement));
                    continue;
                }
                have.addMeasurement(measurement);
            }
        }
        return metricMap;
    }

    public static String meterToKind(Registry registry, Meter meter) {
        String kind = registry.counters().anyMatch(m -> m.id().equals(meter.id())) ? "Counter" : (registry.timers().anyMatch(m -> m.id().equals(meter.id())) ? "Timer" : (registry.distributionSummaries().anyMatch(m -> m.id().equals(meter.id())) ? "Distribution" : (meter instanceof Gauge ? "Gauge" : meter.getClass().getSimpleName())));
        return kind;
    }
}

