/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.perf;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.atlas.AtlasRegistry;
import com.netflix.spectator.perf.ManyTags;
import com.netflix.spectator.perf.NameExplosion;
import com.netflix.spectator.perf.TagKeyExplosion;
import com.netflix.spectator.perf.TagValueExplosion;
import com.netflix.spectator.servo.ServoRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.openjdk.jol.info.GraphLayout;

public final class Main {
    private static final Map<String, Consumer<Registry>> TESTS = new HashMap<String, Consumer<Registry>>();

    private Main() {
    }

    private static Registry createRegistry(String type) {
        NoopRegistry registry = null;
        switch (type) {
            case "noop": {
                registry = new NoopRegistry();
                break;
            }
            case "default": {
                registry = new DefaultRegistry();
                break;
            }
            case "atlas": {
                registry = new AtlasRegistry(Clock.SYSTEM, System::getProperty);
                break;
            }
            case "servo": {
                registry = new ServoRegistry();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown registry type: '" + type + "'");
            }
        }
        return registry;
    }

    public static Registry run(String type, String test) {
        Registry registry = Main.createRegistry(type);
        TESTS.get(test).accept(registry);
        return registry;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: perf <registry> <test>");
            System.exit(1);
        }
        Registry registry = Main.run(args[0], args[1]);
        GraphLayout igraph = GraphLayout.parseInstance((Object[])new Object[]{registry});
        System.out.println(igraph.toFootprint());
    }

    static {
        TESTS.put("many-tags", new ManyTags());
        TESTS.put("name-explosion", new NameExplosion());
        TESTS.put("tag-key-explosion", new TagKeyExplosion());
        TESTS.put("tag-value-explosion", new TagValueExplosion());
    }
}

