/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.netflix.archaius.api.Config;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.gc.GcLogger;
import com.netflix.spectator.jvm.Jmx;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
final class Plugin {
    private static final String ENABLED_PROP = "spectator.nflx.enabled";
    private static final GcLogger GC_LOGGER = new GcLogger();
    private static final Logger LOGGER = LoggerFactory.getLogger(Plugin.class);

    @Inject
    Plugin(Registry registry, @Named(value="spectator") Config config) {
        boolean enabled = config.getBoolean(ENABLED_PROP, Boolean.valueOf(true));
        if (enabled) {
            if (config.getBoolean("spectator.gc.loggingEnabled", Boolean.valueOf(true)).booleanValue()) {
                GC_LOGGER.start(null);
                LOGGER.info("gc logging started");
            } else {
                LOGGER.info("gc logging is not enabled");
            }
            Jmx.registerStandardMXBeans((Registry)registry);
        } else {
            LOGGER.debug("plugin not enabled, set spectator.nflx.enabled=true to enable");
        }
    }
}

