/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Versions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Versions.class);
    private static final String ATLAS_CLIENT_CLASS = "com.netflix.atlas.plugin.SpectatorMetricPoller";

    private static boolean isClassPresent(String className) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = Versions.class.getClassLoader();
            }
            Class.forName(className, false, cl);
            LOGGER.debug("class {} found in classpath", (Object)className);
            return true;
        }
        catch (Throwable t) {
            LOGGER.debug("failed to load class: {}", (Object)className, (Object)t);
            return false;
        }
    }

    static boolean useAtlasRegistry() {
        return Versions.isClassPresent(ATLAS_CLIENT_CLASS);
    }

    private Versions() {
    }
}

