/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.ribbon.transport.netty.RibbonTransport;
import com.netflix.ribbon.transport.netty.http.LoadBalancingHttpClient;
import com.netflix.spectator.api.ExtendedRegistry;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.gc.GcEvent;
import com.netflix.spectator.gc.GcEventListener;
import com.sun.management.GcInfo;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;
import rx.functions.Action1;

public class ChronosGcEventListener
implements GcEventListener {
    private static final DynamicBooleanProperty ENABLED = DynamicPropertyFactory.getInstance().getBooleanProperty("spectator.gc.chronosEnabled", true);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExtendedRegistry registry = Spectator.registry();
    private final Id requestCount = this.registry.createId("spectator.gc.chronosPost");
    private final ObjectMapper mapper = new ObjectMapper();
    private final LoadBalancingHttpClient<ByteBuf, ByteBuf> client = RibbonTransport.newHttpClient((IClientConfig)DefaultClientConfigImpl.getClientConfigWithDefaultValues((String)"chronos_gc", (String)"niws.client"));
    private final AtomicLong previousEndTime = new AtomicLong(-1L);

    private String getenv(String k) {
        String v = System.getenv(k);
        return v == null || v.length() == 0 ? "unknown" : v;
    }

    Map<String, Object> toGcInfoMap(GcEvent event) {
        GcInfo info = event.getInfo().getGcInfo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", info.getId());
        map.put("startTime", event.getStartTime());
        map.put("endTime", event.getStartTime() + info.getDuration());
        map.put("previousEndTime", this.previousEndTime.get());
        map.put("duration", info.getDuration());
        map.put("memoryBeforeGc", info.getMemoryUsageBeforeGc());
        map.put("memoryAfterGc", info.getMemoryUsageAfterGc());
        return map;
    }

    Map<String, Object> toEventMap(GcEvent event) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", event.getInfo().getGcAction());
        map.put("cause", event.getInfo().getGcCause());
        map.put("name", event.getName());
        map.put("gcInfo", this.toGcInfoMap(event));
        map.put("app", this.getenv("NETFLIX_APP"));
        map.put("cluster", this.getenv("NETFLIX_CLUSTER"));
        map.put("asg", this.getenv("NETFLIX_AUTO_SCALE_GROUP"));
        map.put("region", this.getenv("EC2_REGION"));
        map.put("zone", this.getenv("EC2_AVAILABILITY_ZONE"));
        map.put("ami", this.getenv("EC2_AMI_ID"));
        map.put("node", this.getenv("EC2_INSTANCE_ID"));
        return map;
    }

    private void sendToChronos(byte[] json) {
        final ChronosGcEventListener listener = this;
        HttpClientRequest request = HttpClientRequest.createPost((String)"/api/v2/event").withHeader("Content-Type", "application/json").withContent(json);
        final long start = System.nanoTime();
        this.client.submit(request).subscribe((Action1)new Action1<HttpClientResponse<ByteBuf>>(){

            public void call(HttpClientResponse<ByteBuf> response) {
                int code = response.getStatus().code();
                if (code != 200) {
                    ChronosGcEventListener.this.logger.warn("failed to send GC event to chronos (status={})", (Object)code);
                }
                long latency = System.nanoTime() - start;
                ChronosGcEventListener.this.registry.timer(ChronosGcEventListener.this.requestCount.withTag("status", "" + code)).record(latency, TimeUnit.NANOSECONDS);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable t) {
                ChronosGcEventListener.this.logger.warn("failed to send GC event to chronos", t);
                String status = t.getClass().getSimpleName();
                long latency = System.nanoTime() - start;
                ChronosGcEventListener.this.registry.timer(ChronosGcEventListener.this.requestCount.withTag("status", status)).record(latency, TimeUnit.NANOSECONDS);
            }
        }, new Action0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                ChronosGcEventListener chronosGcEventListener = listener;
                synchronized (chronosGcEventListener) {
                    listener.notify();
                }
            }
        });
    }

    public void onComplete(GcEvent event) {
        if (!ENABLED.get()) {
            return;
        }
        try {
            byte[] json = this.mapper.writeValueAsBytes(this.toEventMap(event));
            this.sendToChronos(json);
        }
        catch (IOException e) {
            this.logger.warn("failed to send GC event to chronos", (Throwable)e);
        }
        this.previousEndTime.set(event.getStartTime() + event.getInfo().getGcInfo().getDuration());
    }

    public void shutdown() {
        this.client.shutdown();
    }
}

