/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.netflix.config.ConfigurationManager;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.gc.GcEventListener;
import com.netflix.spectator.gc.GcLogger;
import com.netflix.spectator.jvm.Jmx;
import com.netflix.spectator.nflx.ChronosGcEventListener;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class Plugin {
    private static final String CONFIG_FILE = "spectator.properties";
    private static final GcLogger GC_LOGGER = new GcLogger();
    private static final Logger LOGGER = LoggerFactory.getLogger(Plugin.class);

    @PostConstruct
    private void init() throws IOException {
        boolean enabled = "true".equals(System.getProperty("spectator.nflx.enabled", "true"));
        if (enabled) {
            ConfigurationManager.loadPropertiesFromResources((String)CONFIG_FILE);
            AbstractConfiguration config = ConfigurationManager.getConfigInstance();
            if (config.getBoolean("spectator.gc.loggingEnabled")) {
                GC_LOGGER.start((GcEventListener)new ChronosGcEventListener());
                LOGGER.info("gc logging started");
            } else {
                LOGGER.info("gc logging is not enabled");
            }
            Jmx.registerStandardMXBeans((Registry)Spectator.registry());
        }
        System.setProperty("spectator.nflx.initialized", "true");
    }
}

