/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.aws2;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.ipc.IpcAttempt;
import com.netflix.spectator.ipc.IpcLogEntry;
import com.netflix.spectator.ipc.IpcLogger;
import com.netflix.spectator.ipc.IpcProtocol;
import com.netflix.spectator.ipc.IpcStatus;
import java.util.List;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

public class SpectatorExecutionInterceptor
implements ExecutionInterceptor {
    private static final ExecutionAttribute<IpcLogEntry> LOG_ENTRY = new ExecutionAttribute("SpectatorIpcLogEntry");
    private static final ExecutionAttribute<Boolean> STATUS_IS_SET = new ExecutionAttribute("SpectatorIpcStatusIsSet");
    private final IpcLogger logger;

    public SpectatorExecutionInterceptor() {
        this((Registry)Spectator.globalRegistry());
    }

    public SpectatorExecutionInterceptor(Registry registry) {
        this.logger = new IpcLogger(registry);
    }

    private boolean isStatusSet(ExecutionAttributes attrs) {
        Boolean s = (Boolean)attrs.getAttribute(STATUS_IS_SET);
        return s != null && s != false;
    }

    private void logRetryAttempt(ExecutionAttributes attrs) {
        IpcLogEntry logEntry = (IpcLogEntry)attrs.getAttribute(LOG_ENTRY);
        if (logEntry != null) {
            if (!this.isStatusSet(attrs)) {
                logEntry.markEnd().withStatus(IpcStatus.unexpected_error);
            }
            logEntry.log();
        }
    }

    private void updateAttempts(IpcLogEntry logEntry, SdkHttpRequest request) {
        int attempt = 0;
        int max = 0;
        List vs = (List)request.headers().get("amz-sdk-request");
        if (vs != null) {
            for (String v : vs) {
                int pos = v.indexOf(59);
                if (pos <= 0) continue;
                attempt = this.parseFieldValue(v.substring(0, pos));
                max = this.parseFieldValue(v.substring(pos + 1));
            }
        }
        logEntry.withAttempt(IpcAttempt.forAttemptNumber((int)attempt)).withAttemptFinal(attempt == max);
    }

    private int parseFieldValue(String field) {
        int pos = field.indexOf("=");
        try {
            return pos > 0 ? Integer.parseInt(field.substring(pos + 1)) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes attrs) {
        this.logRetryAttempt(attrs);
        String serviceName = (String)attrs.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String opName = (String)attrs.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        String endpoint = serviceName + "." + opName;
        SdkHttpRequest request = context.httpRequest();
        IpcLogEntry logEntry = this.logger.createClientEntry().withOwner("aws-sdk-java-v2").withProtocol(IpcProtocol.http_1).withHttpMethod(request.method().name()).withUri(request.getUri()).withEndpoint(endpoint);
        this.updateAttempts(logEntry, request);
        request.headers().forEach((k, vs) -> vs.forEach(v -> logEntry.addRequestHeader(k, v)));
        attrs.putAttribute(LOG_ENTRY, (Object)logEntry.markStart());
    }

    public void afterTransmission(Context.AfterTransmission context, ExecutionAttributes attrs) {
        SdkHttpResponse response = context.httpResponse();
        IpcLogEntry logEntry = ((IpcLogEntry)attrs.getAttribute(LOG_ENTRY)).markEnd().withHttpStatus(response.statusCode());
        attrs.putAttribute(STATUS_IS_SET, (Object)true);
        response.headers().forEach((k, vs) -> vs.forEach(v -> logEntry.addResponseHeader(k, v)));
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes attrs) {
        ((IpcLogEntry)attrs.getAttribute(LOG_ENTRY)).log();
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes attrs) {
        IpcLogEntry logEntry = (IpcLogEntry)attrs.getAttribute(LOG_ENTRY);
        Throwable t = context.exception();
        if (t instanceof AwsServiceException) {
            AwsServiceException exception = (AwsServiceException)t;
            if (exception.isThrottlingException()) {
                logEntry.withStatus(IpcStatus.throttled);
            }
            logEntry.withStatusDetail(exception.awsErrorDetails().errorCode());
        }
        logEntry.withException(context.exception()).log();
    }
}

