/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.aws2;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.Preconditions;
import java.beans.Introspector;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.metrics.spi.MetricType;
import software.amazon.awssdk.metrics.spi.TimingInfo;

public class SpectatorRequestMetricCollector
extends RequestMetricCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpectatorRequestMetricCollector.class);
    private static final Set<String> ALL_DEFAULT_TAGS = new HashSet<String>();
    private static final String TAG_ERROR = "error";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_THROTTLE_EXCEPTION = "throttleException";
    private static final String UNKNOWN = "UNKNOWN";
    private static final AwsRequestMetrics.Field[] TIMERS = new AwsRequestMetrics.Field[]{AwsRequestMetrics.Field.ClientExecuteTime, AwsRequestMetrics.Field.CredentialsRequestTime, AwsRequestMetrics.Field.HttpClientReceiveResponseTime, AwsRequestMetrics.Field.HttpClientSendRequestTime, AwsRequestMetrics.Field.HttpRequestTime, AwsRequestMetrics.Field.RequestMarshallTime, AwsRequestMetrics.Field.RequestSigningTime, AwsRequestMetrics.Field.ResponseProcessingTime, AwsRequestMetrics.Field.RetryPauseTime};
    private static final AwsRequestMetrics.Field[] COUNTERS = new AwsRequestMetrics.Field[]{AwsRequestMetrics.Field.BytesProcessed, AwsRequestMetrics.Field.HttpClientRetryCount, AwsRequestMetrics.Field.RequestCount};
    private static final TagField[] TAGS = new TagField[]{new TagField(AwsRequestMetrics.Field.ServiceEndpoint, SpectatorRequestMetricCollector::getHost), new TagField(AwsRequestMetrics.Field.ServiceName), new TagField(AwsRequestMetrics.Field.StatusCode)};
    private static final TagField[] ERRORS = new TagField[]{new TagField(AwsRequestMetrics.Field.AWSErrorCode), new TagField(AwsRequestMetrics.Field.Exception, e -> e.getClass().getSimpleName())};
    private final Registry registry;
    private final Map<String, String> customTags;

    public SpectatorRequestMetricCollector(Registry registry) {
        this(registry, Collections.emptyMap());
    }

    public SpectatorRequestMetricCollector(Registry registry, Map<String, String> customTags) {
        this.registry = (Registry)Preconditions.checkNotNull((Object)registry, (String)"registry");
        Preconditions.checkNotNull(customTags, (String)"customTags");
        this.customTags = new HashMap<String, String>();
        customTags.forEach((key, value) -> {
            if (ALL_DEFAULT_TAGS.contains(key)) {
                registry.propagate((Throwable)new IllegalArgumentException("Invalid custom tag " + key + " - cannot override built-in tag"));
            } else {
                this.customTags.put((String)key, (String)value);
            }
        });
    }

    public void collectMetrics(Request<?> request, Object response) {
        AwsRequestMetrics metrics = request.getAwsRequestMetrics();
        if (metrics.isEnabled()) {
            Map<String, String> allTags = this.getAllTags(request);
            TimingInfo timing = metrics.getTimingInfo();
            for (AwsRequestMetrics.Field counter : COUNTERS) {
                Optional.ofNullable(timing.getCounter(counter.name())).filter(v -> v.longValue() > 0L).ifPresent(v -> this.registry.counter(this.metricId(counter, allTags)).increment(v.longValue()));
            }
            for (AwsRequestMetrics.Field timer : TIMERS) {
                Optional.ofNullable(timing.getLastSubMeasurement(timer.name())).filter(TimingInfo::isEndTimeKnown).ifPresent(t -> this.registry.timer(this.metricId(timer, allTags)).record(t.getEndTimeNano() - t.getStartTimeNano(), TimeUnit.NANOSECONDS));
            }
            SpectatorRequestMetricCollector.notEmpty(metrics.getProperty((MetricType)AwsRequestMetrics.Field.ThrottleException)).ifPresent(throttleExceptions -> {
                Id throttling = this.metricId("throttling", allTags);
                throttleExceptions.forEach(ex -> this.registry.counter(throttling.withTag(TAG_THROTTLE_EXCEPTION, ex.getClass().getSimpleName())).increment());
            });
        }
    }

    private Id metricId(AwsRequestMetrics.Field metric, Map<String, String> tags) {
        return this.metricId(metric.name(), tags);
    }

    private Id metricId(String metric, Map<String, String> tags) {
        return this.registry.createId(SpectatorRequestMetricCollector.idName(metric), tags);
    }

    private Map<String, String> getAllTags(Request<?> request) {
        AwsRequestMetrics metrics = request.getAwsRequestMetrics();
        HashMap<String, String> allTags = new HashMap<String, String>();
        for (TagField tag : TAGS) {
            allTags.put(tag.getName(), tag.getValue(metrics).orElse(UNKNOWN));
        }
        allTags.put(TAG_REQUEST_TYPE, request.getOriginalRequest().getClass().getSimpleName());
        boolean error = SpectatorRequestMetricCollector.isError(metrics);
        if (error) {
            for (TagField tag : ERRORS) {
                allTags.put(tag.getName(), tag.getValue(metrics).orElse(UNKNOWN));
            }
        }
        allTags.put(TAG_ERROR, Boolean.toString(error));
        allTags.putAll(this.customTags);
        return Collections.unmodifiableMap(allTags);
    }

    static String idName(String name) {
        return "aws.request." + Introspector.decapitalize(name);
    }

    private static Optional<List<Object>> notEmpty(List<Object> properties) {
        return Optional.ofNullable(properties).filter(v -> !v.isEmpty());
    }

    static <R> Optional<R> firstValue(List<Object> properties, Function<Object, R> transform) {
        return SpectatorRequestMetricCollector.notEmpty(properties).map(v -> v.get(0)).map(transform::apply);
    }

    private static boolean isError(AwsRequestMetrics metrics) {
        for (TagField err : ERRORS) {
            if (!err.getValue(metrics).isPresent()) continue;
            return true;
        }
        return false;
    }

    private static String getHost(Object u) {
        try {
            return URI.create(u.toString()).getHost();
        }
        catch (Exception e) {
            LOGGER.debug("failed to parse endpoint uri: " + u, (Throwable)e);
            return UNKNOWN;
        }
    }

    static {
        Stream.concat(Arrays.stream(TAGS), Arrays.stream(ERRORS)).map(TagField::getName).forEach(ALL_DEFAULT_TAGS::add);
        ALL_DEFAULT_TAGS.addAll(Arrays.asList(TAG_THROTTLE_EXCEPTION, TAG_REQUEST_TYPE, TAG_ERROR));
    }

    private static class TagField {
        private final AwsRequestMetrics.Field field;
        private final String name;
        private final Function<Object, String> tagExtractor;

        TagField(AwsRequestMetrics.Field field) {
            this(field, Object::toString);
        }

        TagField(AwsRequestMetrics.Field field, Function<Object, String> tagExtractor) {
            this.field = field;
            this.tagExtractor = tagExtractor;
            this.name = Introspector.decapitalize(field.name());
        }

        String getName() {
            return this.name;
        }

        Optional<String> getValue(AwsRequestMetrics metrics) {
            return SpectatorRequestMetricCollector.firstValue(metrics.getProperty((MetricType)this.field), this.tagExtractor);
        }
    }
}

