/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.aws2;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.aws2.SpectatorRequestMetricCollector;
import com.netflix.spectator.impl.Preconditions;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.ServiceMetricCollector;

public class SpectatorMetricCollector
extends MetricCollector {
    private final RequestMetricCollector requestMetricCollector;

    public SpectatorMetricCollector(Registry registry) {
        Preconditions.checkNotNull((Object)registry, (String)"registry");
        this.requestMetricCollector = new SpectatorRequestMetricCollector(registry);
    }

    public boolean start() {
        return true;
    }

    public void stop() {
    }

    public boolean isEnabled() {
        return Boolean.valueOf(System.getProperty("spectator.ext.aws.enabled", "true"));
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public ServiceMetricCollector getServiceMetricCollector() {
        return ServiceMetricCollector.NONE;
    }
}

