/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.aws;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.Preconditions;
import java.beans.Introspector;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectatorRequestMetricCollector
extends RequestMetricCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpectatorRequestMetricCollector.class);
    private static final String UNKNOWN = "UNKNOWN";
    private static final AWSRequestMetrics.Field[] TIMERS = new AWSRequestMetrics.Field[]{AWSRequestMetrics.Field.ClientExecuteTime, AWSRequestMetrics.Field.CredentialsRequestTime, AWSRequestMetrics.Field.HttpClientReceiveResponseTime, AWSRequestMetrics.Field.HttpClientSendRequestTime, AWSRequestMetrics.Field.HttpRequestTime, AWSRequestMetrics.Field.RequestMarshallTime, AWSRequestMetrics.Field.RequestSigningTime, AWSRequestMetrics.Field.ResponseProcessingTime, AWSRequestMetrics.Field.RetryPauseTime};
    private static final AWSRequestMetrics.Field[] COUNTERS = new AWSRequestMetrics.Field[]{AWSRequestMetrics.Field.BytesProcessed, AWSRequestMetrics.Field.HttpClientRetryCount, AWSRequestMetrics.Field.RequestCount};
    private static final TagField[] TAGS = new TagField[]{new TagField(AWSRequestMetrics.Field.ServiceEndpoint, SpectatorRequestMetricCollector::getHost), new TagField(AWSRequestMetrics.Field.ServiceName), new TagField(AWSRequestMetrics.Field.StatusCode)};
    private static final TagField[] ERRORS = new TagField[]{new TagField(AWSRequestMetrics.Field.AWSErrorCode), new TagField(AWSRequestMetrics.Field.Exception, e -> e.getClass().getSimpleName())};
    private final Registry registry;

    public SpectatorRequestMetricCollector(Registry registry) {
        this.registry = (Registry)Preconditions.checkNotNull((Object)registry, (String)"registry");
    }

    public void collectMetrics(Request<?> request, Response<?> response) {
        AWSRequestMetrics metrics = request.getAWSRequestMetrics();
        if (metrics.isEnabled()) {
            Map<String, String> baseTags = this.getBaseTags(request);
            TimingInfo timing = metrics.getTimingInfo();
            for (AWSRequestMetrics.Field counter : COUNTERS) {
                Optional.ofNullable(timing.getCounter(counter.name())).filter(v -> v.longValue() > 0L).ifPresent(v -> this.registry.counter(this.metricId(counter, baseTags)).increment(v.longValue()));
            }
            for (AWSRequestMetrics.Field timer : TIMERS) {
                Optional.ofNullable(timing.getLastSubMeasurement(timer.name())).filter(TimingInfo::isEndTimeKnown).ifPresent(t -> this.registry.timer(this.metricId(timer, baseTags)).record(t.getEndTimeNano() - t.getStartTimeNano(), TimeUnit.NANOSECONDS));
            }
            SpectatorRequestMetricCollector.notEmpty(metrics.getProperty((MetricType)AWSRequestMetrics.Field.ThrottleException)).ifPresent(throttleExceptions -> {
                Id throttling = this.metricId("throttling", baseTags);
                throttleExceptions.forEach(ex -> this.registry.counter(throttling.withTag("throttleException", ex.getClass().getSimpleName())).increment());
            });
        }
    }

    private Id metricId(AWSRequestMetrics.Field metric, Map<String, String> tags) {
        return this.metricId(metric.name(), tags);
    }

    private Id metricId(String metric, Map<String, String> tags) {
        return this.registry.createId(SpectatorRequestMetricCollector.idName(metric), tags);
    }

    private Map<String, String> getBaseTags(Request<?> request) {
        AWSRequestMetrics metrics = request.getAWSRequestMetrics();
        HashMap<String, String> baseTags = new HashMap<String, String>();
        for (TagField tag : TAGS) {
            baseTags.put(tag.getName(), tag.getValue(metrics).orElse(UNKNOWN));
        }
        baseTags.put("requestType", request.getOriginalRequest().getClass().getSimpleName());
        boolean error = SpectatorRequestMetricCollector.isError(metrics);
        if (error) {
            for (TagField tag : ERRORS) {
                baseTags.put(tag.getName(), tag.getValue(metrics).orElse(UNKNOWN));
            }
        }
        baseTags.put("error", Boolean.toString(error));
        return Collections.unmodifiableMap(baseTags);
    }

    static String idName(String name) {
        return "aws.request." + Introspector.decapitalize(name);
    }

    private static Optional<List<Object>> notEmpty(List<Object> properties) {
        return Optional.ofNullable(properties).filter(v -> !v.isEmpty());
    }

    static <R> Optional<R> firstValue(List<Object> properties, Function<Object, R> transform) {
        return SpectatorRequestMetricCollector.notEmpty(properties).map(v -> v.get(0)).map(transform::apply);
    }

    private static boolean isError(AWSRequestMetrics metrics) {
        for (TagField err : ERRORS) {
            if (!err.getValue(metrics).isPresent()) continue;
            return true;
        }
        return false;
    }

    private static String getHost(Object u) {
        try {
            return URI.create(u.toString()).getHost();
        }
        catch (Exception e) {
            LOGGER.debug("failed to parse endpoint uri: " + u, (Throwable)e);
            return UNKNOWN;
        }
    }

    private static class TagField {
        private final AWSRequestMetrics.Field field;
        private final String name;
        private final Function<Object, String> tagExtractor;

        public TagField(AWSRequestMetrics.Field field) {
            this(field, Object::toString);
        }

        public TagField(AWSRequestMetrics.Field field, Function<Object, String> tagExtractor) {
            this.field = field;
            this.tagExtractor = tagExtractor;
            this.name = Introspector.decapitalize(field.name());
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getValue(AWSRequestMetrics metrics) {
            return SpectatorRequestMetricCollector.firstValue(metrics.getProperty((MetricType)this.field), this.tagExtractor);
        }
    }
}

