/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ArrayTagSet;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.impl.Preconditions;
import java.util.Arrays;

public final class TagListBuilder {
    private final int basePos;
    private final String baseKey;
    private final boolean baseSorted;
    private String[] tags;
    private int pos;
    private String lastKey;
    private boolean sorted;

    public static TagListBuilder create() {
        return new TagListBuilder(ArrayTagSet.EMPTY);
    }

    public static TagListBuilder create(TagList baseTags) {
        return new TagListBuilder(Preconditions.checkNotNull(baseTags, "baseTags"));
    }

    TagListBuilder(TagList baseTags) {
        int n = baseTags.size() * 2 + 20;
        this.tags = new String[n];
        this.pos = 0;
        this.lastKey = null;
        this.sorted = true;
        this.add(baseTags);
        this.basePos = this.pos;
        this.baseKey = this.lastKey;
        this.baseSorted = this.sorted;
    }

    boolean isSorted() {
        return this.sorted;
    }

    private void resizeIfNeeded() {
        if (this.pos >= this.tags.length) {
            this.tags = Arrays.copyOf(this.tags, this.tags.length * 2);
        }
    }

    private boolean isGreaterThanLastKey(String key) {
        return this.lastKey == null || this.lastKey.compareTo(key) < 0;
    }

    public TagListBuilder add(TagList tags) {
        int n = tags.size();
        for (int i = 0; i < n; ++i) {
            this.add(tags.getKey(i), tags.getValue(i));
        }
        return this;
    }

    public TagListBuilder add(String key, String value) {
        if (key != null && value != null) {
            this.resizeIfNeeded();
            this.sorted = this.sorted && this.isGreaterThanLastKey(key);
            this.lastKey = key;
            this.tags[this.pos++] = key;
            this.tags[this.pos++] = value;
        }
        return this;
    }

    public TagListBuilder add(Tag tag) {
        return this.add(tag.key(), tag.value());
    }

    public void reset() {
        this.pos = this.basePos;
        this.lastKey = this.baseKey;
        this.sorted = this.baseSorted;
    }

    public TagList buildAndReset() {
        String[] copy = Arrays.copyOf(this.tags, this.pos);
        ArrayTagSet ts = ArrayTagSet.EMPTY.addAll(copy, this.pos, this.sorted, this.sorted);
        this.reset();
        return ts;
    }
}

