/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.SwapMeter;

final class SwapDistributionSummary
implements DistributionSummary,
SwapMeter<DistributionSummary> {
    private final Registry registry;
    private final Id id;
    private volatile DistributionSummary underlying;

    SwapDistributionSummary(Registry registry, Id id, DistributionSummary underlying) {
        this.registry = registry;
        this.id = id;
        this.underlying = underlying;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public boolean hasExpired() {
        DistributionSummary d = this.underlying;
        return d == null || d.hasExpired();
    }

    @Override
    public void record(long amount) {
        this.get().record(amount);
    }

    @Override
    public long count() {
        return this.get().count();
    }

    @Override
    public long totalAmount() {
        return this.get().totalAmount();
    }

    @Override
    public void set(DistributionSummary d) {
        this.underlying = d;
    }

    @Override
    public DistributionSummary get() {
        DistributionSummary d = this.underlying;
        if (d == null) {
            this.underlying = d = this.unwrap(this.registry.distributionSummary(this.id));
        }
        return d;
    }

    private DistributionSummary unwrap(DistributionSummary d) {
        DistributionSummary tmp = d;
        while (tmp instanceof SwapDistributionSummary) {
            tmp = ((SwapDistributionSummary)tmp).get();
        }
        return tmp;
    }
}

