/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Functions;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.LongTaskTimer;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopGauge;
import com.netflix.spectator.api.ObjectGauge;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.impl.Config;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.LoggerFactory;

public interface Registry
extends Iterable<Meter> {
    public Clock clock();

    default public RegistryConfig config() {
        return Config.defaultConfig();
    }

    public Id createId(String var1);

    public Id createId(String var1, Iterable<Tag> var2);

    public void register(Meter var1);

    public ConcurrentMap<Id, Object> state();

    public Counter counter(Id var1);

    public DistributionSummary distributionSummary(Id var1);

    public Timer timer(Id var1);

    default public Gauge gauge(Id id) {
        return NoopGauge.INSTANCE;
    }

    public Meter get(Id var1);

    @Override
    public Iterator<Meter> iterator();

    default public <T extends Registry> T underlying(Class<T> c) {
        if (c.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this instanceof CompositeRegistry) {
            return ((CompositeRegistry)this).find(c);
        }
        return null;
    }

    default public Id createId(String name, String ... tags) {
        return this.createId(name, Utils.toIterable(tags));
    }

    default public Id createId(String name, Map<String, String> tags) {
        return this.createId(name).withTags(tags);
    }

    default public Counter counter(String name) {
        return this.counter(this.createId(name));
    }

    default public Counter counter(String name, Iterable<Tag> tags) {
        return this.counter(this.createId(name, tags));
    }

    default public Counter counter(String name, String ... tags) {
        return this.counter(this.createId(name, Utils.toIterable(tags)));
    }

    default public DistributionSummary distributionSummary(String name) {
        return this.distributionSummary(this.createId(name));
    }

    default public DistributionSummary distributionSummary(String name, Iterable<Tag> tags) {
        return this.distributionSummary(this.createId(name, tags));
    }

    default public DistributionSummary distributionSummary(String name, String ... tags) {
        return this.distributionSummary(this.createId(name, Utils.toIterable(tags)));
    }

    default public Timer timer(String name) {
        return this.timer(this.createId(name));
    }

    default public Timer timer(String name, Iterable<Tag> tags) {
        return this.timer(this.createId(name, tags));
    }

    default public Timer timer(String name, String ... tags) {
        return this.timer(this.createId(name, Utils.toIterable(tags)));
    }

    default public LongTaskTimer longTaskTimer(Id id) {
        return com.netflix.spectator.api.patterns.LongTaskTimer.get(this, id);
    }

    default public LongTaskTimer longTaskTimer(String name) {
        return this.longTaskTimer(this.createId(name));
    }

    default public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return this.longTaskTimer(this.createId(name, tags));
    }

    default public LongTaskTimer longTaskTimer(String name, String ... tags) {
        return this.longTaskTimer(this.createId(name, Utils.toIterable(tags)));
    }

    default public <T extends Number> T gauge(Id id, T number) {
        return (T)this.gauge(id, number, Number::doubleValue);
    }

    default public <T extends Number> T gauge(String name, T number) {
        return this.gauge(this.createId(name), number);
    }

    default public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return this.gauge(this.createId(name, tags), number);
    }

    default public <T> T gauge(Id id, T obj, ToDoubleFunction<T> f) {
        this.register(new ObjectGauge<T>(this.clock(), id, obj, f));
        return obj;
    }

    default public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(this.createId(name), obj, f);
    }

    default public <T extends Collection<?>> T collectionSize(Id id, T collection) {
        return (T)this.gauge(id, collection, Collection::size);
    }

    default public <T extends Collection<?>> T collectionSize(String name, T collection) {
        return this.collectionSize(this.createId(name), collection);
    }

    default public <T extends Map<?, ?>> T mapSize(Id id, T collection) {
        return (T)this.gauge(id, collection, Map::size);
    }

    default public <T extends Map<?, ?>> T mapSize(String name, T collection) {
        return this.mapSize(this.createId(name), collection);
    }

    default public void methodValue(Id id, Object obj, String method) {
        Method m = Utils.getGaugeMethod(this, id, obj, method);
        if (m != null) {
            this.gauge(id, obj, Functions.invokeMethod(m));
        }
    }

    default public void methodValue(String name, Object obj, String method) {
        this.methodValue(this.createId(name), obj, method);
    }

    default public Stream<Meter> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<Counter> counters() {
        return this.stream().filter(m -> m instanceof Counter).map(m -> (Counter)m);
    }

    default public Stream<DistributionSummary> distributionSummaries() {
        return this.stream().filter(m -> m instanceof DistributionSummary).map(m -> (DistributionSummary)m);
    }

    default public Stream<Timer> timers() {
        return this.stream().filter(m -> m instanceof Timer).map(m -> (Timer)m);
    }

    default public void propagate(String msg, Throwable t) {
        LoggerFactory.getLogger(this.getClass()).warn(msg, t);
        if (this.config().propagateWarnings()) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    default public void propagate(Throwable t) {
        this.propagate(t.getMessage(), t);
    }
}

