/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileBuckets;
import java.util.Collections;

public class PercentileDistributionSummary
implements DistributionSummary {
    private final Id id;
    private final DistributionSummary summary;
    private final Counter[] counters;

    public static PercentileDistributionSummary get(Registry registry, Id id) {
        return new PercentileDistributionSummary(registry, id);
    }

    PercentileDistributionSummary(Registry registry, Id id) {
        this.id = id;
        this.summary = registry.distributionSummary(id);
        this.counters = new Counter[PercentileBuckets.length()];
        for (int i = 0; i < this.counters.length; ++i) {
            Id counterId = id.withTag("percentile", String.format("D%04X", i));
            this.counters[i] = registry.counter(counterId);
        }
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return this.summary.hasExpired();
    }

    @Override
    public void record(long amount) {
        if (amount >= 0L) {
            this.summary.record(amount);
            this.counters[PercentileBuckets.indexOf(amount)].increment();
        }
    }

    public double percentile(double p) {
        long[] counts = new long[PercentileBuckets.length()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.counters[i].count();
        }
        return PercentileBuckets.percentile(counts, p);
    }

    @Override
    public long count() {
        return this.summary.count();
    }

    @Override
    public long totalAmount() {
        return this.summary.totalAmount();
    }
}

