/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.FilteredIterator;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.api.Throwables;
import com.netflix.spectator.impl.Preconditions;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger REGISTRY_LOGGER = LoggerFactory.getLogger(Registry.class);

    private Utils() {
    }

    static Method getMethod(Class<?> cls, String name) throws NoSuchMethodException {
        NoSuchMethodException firstExc = null;
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (firstExc != null) continue;
                firstExc = e;
                continue;
            }
        }
        throw firstExc;
    }

    static Method getGaugeMethod(Id id, Object obj, String method) {
        try {
            Method m = Utils.getMethod(obj.getClass(), method);
            try {
                Number n = (Number)m.invoke(obj, new Object[0]);
                REGISTRY_LOGGER.debug("registering gauge {}, using method [{}], with initial value {}", new Object[]{id, m, n});
                return m;
            }
            catch (Exception e) {
                String msg = "exception thrown invoking method [" + m + "], skipping registration of gauge " + id;
                Throwables.propagate(msg, e);
            }
        }
        catch (NoSuchMethodException e) {
            String mname = obj.getClass().getName() + "." + method;
            String msg = "invalid method [" + mname + "], skipping registration of gauge " + id;
            Throwables.propagate(msg, e);
        }
        return null;
    }

    public static Id normalize(Id id) {
        return ((DefaultId)new DefaultId(id.name()).withTags((Iterable)id.tags())).normalize();
    }

    public static String getTagValue(Id id, String k) {
        Preconditions.checkNotNull(id, "id");
        return Utils.getTagValue(id.tags(), k);
    }

    public static String getTagValue(Iterable<Tag> tags, String k) {
        Preconditions.checkNotNull(tags, "tags");
        Preconditions.checkNotNull(k, "key");
        for (Tag t : tags) {
            if (!k.equals(t.key())) continue;
            return t.value();
        }
        return null;
    }

    public static Measurement first(Iterable<Measurement> ms, Tag t) {
        return Utils.first(ms, t.key(), t.value());
    }

    public static Measurement first(Iterable<Measurement> ms, String k, String v) {
        return Utils.first(ms, (Measurement value) -> v.equals(Utils.getTagValue(value.id(), k)));
    }

    public static Measurement first(Iterable<Measurement> ms, Predicate<Measurement> p) {
        Iterator<Measurement> it = Utils.filter(ms, p).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, Tag t) {
        return Utils.filter(ms, t.key(), t.value());
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, String k, String v) {
        return Utils.filter(ms, (Measurement value) -> v.equals(Utils.getTagValue(value.id(), k)));
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, Predicate<Measurement> p) {
        return () -> new FilteredIterator(ms.iterator(), p);
    }

    public static <T> List<T> toList(Iterable<T> iter) {
        ArrayList<T> buf = new ArrayList<T>();
        for (T v : iter) {
            buf.add(v);
        }
        return buf;
    }

    public static <T> List<T> toList(Iterator<T> iter) {
        ArrayList<T> buf = new ArrayList<T>();
        while (iter.hasNext()) {
            buf.add(iter.next());
        }
        return buf;
    }

    static Iterable<Tag> toIterable(String[] tags) {
        if (tags.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        ArrayList<Tag> ts = new ArrayList<Tag>(tags.length);
        for (int i = 0; i < tags.length; i += 2) {
            ts.add(new TagList(tags[i], tags[i + 1]));
        }
        return ts;
    }
}

