/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ConstantTagFactory;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DynamicId;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagFactory;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.impl.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class DefaultDynamicId
implements DynamicId {
    private final String name;
    private final Collection<TagFactory> tagFactories;

    static DefaultDynamicId createWithFactories(String name, Iterable<TagFactory> tagFactories) {
        if (tagFactories == null) {
            return new DefaultDynamicId(name);
        }
        FactorySorterAndDeduplicator sorter = new FactorySorterAndDeduplicator(tagFactories);
        return new DefaultDynamicId(name, sorter.asCollection());
    }

    DefaultDynamicId(String name) {
        this(name, Collections.emptyList());
    }

    private DefaultDynamicId(String name, Collection<TagFactory> tagFactories) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.tagFactories = tagFactories;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<Tag> tags() {
        return this.tagFactories.stream().map(factory -> factory.createTag()).filter(tag -> tag != null).collect(Collectors.toList());
    }

    @Override
    public DefaultDynamicId withTag(String k, String v) {
        return this.withTagFactory(new ConstantTagFactory(new TagList(k, v)));
    }

    @Override
    public DefaultDynamicId withTag(Tag t) {
        return this.withTagFactory(new ConstantTagFactory(t));
    }

    @Override
    public DefaultDynamicId withTags(Iterable<Tag> tags) {
        return this.createNewId(sorter -> tags.forEach(tag -> sorter.addFactory(new ConstantTagFactory((Tag)tag))));
    }

    @Override
    public DefaultDynamicId withTags(Map<String, String> tags) {
        return this.createNewId(sorter -> tags.forEach((key, value) -> sorter.addFactory(new ConstantTagFactory(new TagList((String)key, (String)value)))));
    }

    @Override
    public DefaultDynamicId withTagFactory(TagFactory factory) {
        if (this.tagFactories.isEmpty()) {
            return new DefaultDynamicId(this.name, Collections.singleton(factory));
        }
        return this.createNewId(sorter -> sorter.addFactory(factory));
    }

    @Override
    public DefaultDynamicId withTagFactories(Iterable<TagFactory> factories) {
        return this.createNewId(sorter -> sorter.addFactories(factories));
    }

    @Override
    public Id resolveToId() {
        return new DefaultId(this.name, TagList.create(this.tags()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamicId that = (DefaultDynamicId)o;
        return this.name.equals(that.name) && this.tagFactories.size() == that.tagFactories.size() && this.tagFactories.containsAll(that.tagFactories);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.tagFactories.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        if (!this.tagFactories.isEmpty()) {
            for (Tag cur : this.tags()) {
                buf.append(":").append(cur.key()).append("=").append(cur.value());
            }
        }
        return buf.toString();
    }

    private DefaultDynamicId createNewId(Consumer<FactorySorterAndDeduplicator> consumer) {
        FactorySorterAndDeduplicator sorter = new FactorySorterAndDeduplicator(this.tagFactories);
        consumer.accept(sorter);
        return new DefaultDynamicId(this.name, sorter.asCollection());
    }

    private static final class FactorySorterAndDeduplicator {
        private final Map<String, TagFactory> map = new TreeMap<String, TagFactory>();

        FactorySorterAndDeduplicator(Iterable<TagFactory> tagFactories) {
            this.addFactories(tagFactories);
        }

        void addFactory(TagFactory factory) {
            this.map.put(factory.name(), factory);
        }

        void addFactories(Iterable<TagFactory> factories) {
            for (TagFactory factory : factories) {
                this.map.put(factory.name(), factory);
            }
        }

        Collection<TagFactory> asCollection() {
            return Collections.unmodifiableCollection(this.map.values());
        }
    }
}

