/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeCounter;
import com.netflix.spectator.api.CompositeDistributionSummary;
import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.CompositeTimer;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryMeter;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.api.Timer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;

public final class CompositeRegistry
implements Registry {
    static final Id GAUGES_ID = new DefaultId("spectator.composite.gauges");
    private final Clock clock;
    private final CopyOnWriteArraySet<Registry> registries;
    private final RegistryMeter gauges;

    CompositeRegistry(Clock clock) {
        this.clock = clock;
        this.registries = new CopyOnWriteArraySet();
        this.gauges = new RegistryMeter(GAUGES_ID);
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    public void add(Registry registry) {
        this.registries.add(registry);
        registry.register(this.gauges);
    }

    public void remove(Registry registry) {
        this.registries.remove(registry);
    }

    public void removeAll() {
        this.registries.clear();
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, TagList.create(tags));
    }

    @Override
    public void register(Meter meter) {
        this.gauges.register(meter);
    }

    @Override
    public Counter counter(Id id) {
        return new CompositeCounter(id, this.registries);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new CompositeDistributionSummary(id, this.registries);
    }

    @Override
    public Timer timer(Id id) {
        return new CompositeTimer(id, this.clock, this.registries);
    }

    @Override
    public Meter get(Id id) {
        return new CompositeMeter(id, this.registries);
    }

    @Override
    public Iterator<Meter> iterator() {
        if (this.registries.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        final HashSet<Id> ids = new HashSet<Id>();
        for (Registry r : this.registries) {
            for (Meter m : r) {
                ids.add(m.id());
            }
        }
        return new Iterator<Meter>(){
            private final Iterator<Id> idIter;
            {
                this.idIter = ids.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.idIter.hasNext();
            }

            @Override
            public Meter next() {
                return CompositeRegistry.this.get(this.idIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

