/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeCounter;
import com.netflix.spectator.api.CompositeDistributionSummary;
import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.CompositeTimer;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopCounter;
import com.netflix.spectator.api.NoopDistributionSummary;
import com.netflix.spectator.api.NoopTimer;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.api.Timer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

final class CompositeRegistry
implements Registry {
    private final Clock clock;
    private final Registry[] registries;

    CompositeRegistry(Clock clock, Registry[] registries) {
        this.clock = clock;
        this.registries = registries;
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, TagList.create(tags));
    }

    @Override
    public void register(Meter meter) {
        for (Registry r : this.registries) {
            r.register(meter);
        }
    }

    @Override
    public Counter counter(Id id) {
        int n = this.registries.length;
        if (n == 0) {
            return NoopCounter.INSTANCE;
        }
        Counter[] meters = new Counter[n];
        for (int i = 0; i < n; ++i) {
            meters[i] = this.registries[i].counter(this.registries[i].createId(id.name(), id.tags()));
        }
        return new CompositeCounter(id, meters);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        int n = this.registries.length;
        if (n == 0) {
            return NoopDistributionSummary.INSTANCE;
        }
        DistributionSummary[] meters = new DistributionSummary[n];
        for (int i = 0; i < n; ++i) {
            meters[i] = this.registries[i].distributionSummary(this.registries[i].createId(id.name(), id.tags()));
        }
        return new CompositeDistributionSummary(id, meters);
    }

    @Override
    public Timer timer(Id id) {
        int n = this.registries.length;
        if (n == 0) {
            return NoopTimer.INSTANCE;
        }
        Timer[] meters = new Timer[n];
        for (int i = 0; i < n; ++i) {
            meters[i] = this.registries[i].timer(this.registries[i].createId(id.name(), id.tags()));
        }
        return new CompositeTimer(id, this.clock, meters);
    }

    @Override
    public Meter get(Id id) {
        int n = this.registries.length;
        if (n == 0) {
            return null;
        }
        final Meter[] meters = new Meter[n];
        for (int i = 0; i < n; ++i) {
            meters[i] = this.registries[i].get(this.registries[i].createId(id.name(), id.tags()));
        }
        return new CompositeMeter(id){

            @Override
            protected Meter[] meters() {
                return meters;
            }
        };
    }

    @Override
    public Iterator<Meter> iterator() {
        if (this.registries.length == 0) {
            return Collections.emptyList().iterator();
        }
        final HashSet<Id> ids = new HashSet<Id>();
        for (Registry r : this.registries) {
            for (Meter m : r) {
                ids.add(m.id());
            }
        }
        return new Iterator<Meter>(){
            private final Iterator<Id> idIter;
            {
                this.idIter = ids.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.idIter.hasNext();
            }

            @Override
            public Meter next() {
                return CompositeRegistry.this.get(this.idIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

