/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.FilteredIterator;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Predicate;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static String getTagValue(Id id, String k) {
        Preconditions.checkNotNull(id, "id");
        return Utils.getTagValue(id.tags(), k);
    }

    public static String getTagValue(Iterable<Tag> tags, String k) {
        Preconditions.checkNotNull(tags, "tags");
        Preconditions.checkNotNull(k, "key");
        for (Tag t : tags) {
            if (!k.equals(t.key())) continue;
            return t.value();
        }
        return null;
    }

    public static Measurement first(Iterable<Measurement> ms, Tag t) {
        return Utils.first(ms, t.key(), t.value());
    }

    public static Measurement first(Iterable<Measurement> ms, final String k, final String v) {
        return Utils.first(ms, new Predicate<Measurement>(){

            @Override
            public boolean apply(Measurement value) {
                return v.equals(Utils.getTagValue(value.id(), k));
            }
        });
    }

    public static Measurement first(Iterable<Measurement> ms, Predicate<Measurement> p) {
        Iterator<Measurement> it = Utils.filter(ms, p).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, Tag t) {
        return Utils.filter(ms, t.key(), t.value());
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, final String k, final String v) {
        return Utils.filter(ms, new Predicate<Measurement>(){

            @Override
            public boolean apply(Measurement value) {
                return v.equals(Utils.getTagValue(value.id(), k));
            }
        });
    }

    public static Iterable<Measurement> filter(final Iterable<Measurement> ms, final Predicate<Measurement> p) {
        return new Iterable<Measurement>(){

            @Override
            public Iterator<Measurement> iterator() {
                return new FilteredIterator<Measurement>(ms.iterator(), p);
            }
        };
    }

    public static <T> List<T> toList(Iterable<T> iter) {
        ArrayList<T> buf = new ArrayList<T>();
        for (T v : iter) {
            buf.add(v);
        }
        return buf;
    }

    public static <T> List<T> toList(Iterator<T> iter) {
        ArrayList<T> buf = new ArrayList<T>();
        while (iter.hasNext()) {
            buf.add(iter.next());
        }
        return buf;
    }
}

