/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl.matcher;

import com.netflix.spectator.impl.Preconditions;
import com.netflix.spectator.impl.matcher.AnyMatcher;
import com.netflix.spectator.impl.matcher.EndMatcher;
import com.netflix.spectator.impl.matcher.GreedyMatcher;
import com.netflix.spectator.impl.matcher.Matcher;
import com.netflix.spectator.impl.matcher.SeqMatcher;
import com.netflix.spectator.impl.matcher.TrueMatcher;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

final class ZeroOrMoreMatcher
implements GreedyMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Matcher repeated;
    private final Matcher next;

    ZeroOrMoreMatcher(Matcher repeated, Matcher next) {
        this.repeated = repeated;
        this.next = Preconditions.checkNotNull(next, "next");
    }

    Matcher repeated() {
        return this.repeated;
    }

    Matcher next() {
        return this.next;
    }

    @Override
    public int matches(String str, int start, int length) {
        int end = start + length;
        if (this.repeated instanceof AnyMatcher) {
            int stop = end - this.next.minLength();
            for (int pos = start; pos >= 0 && pos <= stop; ++pos) {
                int p = this.next.matches(str, pos, end - pos);
                if (p < start) continue;
                return p;
            }
            return -1;
        }
        if (this.next != TrueMatcher.INSTANCE) {
            int stop = end - this.next.minLength();
            int pos = start;
            while (pos >= start && pos <= stop) {
                int p = this.next.matches(str, pos, end - pos);
                if (p >= start) {
                    return p;
                }
                int tmp = this.repeated.matches(str, pos, end - pos);
                if (tmp == pos) {
                    return -1;
                }
                pos = tmp;
            }
            return -1;
        }
        int matchPos = -1;
        int pos = start;
        while (pos > matchPos) {
            matchPos = pos;
            pos = this.repeated.matches(str, pos, end - pos);
        }
        return matchPos;
    }

    @Override
    public int minLength() {
        return this.next.minLength();
    }

    @Override
    public boolean isEndAnchored() {
        return this.next.isEndAnchored();
    }

    @Override
    public boolean alwaysMatches() {
        return this.repeated instanceof AnyMatcher && (this.next instanceof TrueMatcher || this.next instanceof EndMatcher);
    }

    @Override
    public Matcher mergeNext(Matcher after) {
        if (after instanceof TrueMatcher) {
            return this;
        }
        Matcher m = this.next instanceof TrueMatcher ? after : SeqMatcher.create(this.next, after);
        return new ZeroOrMoreMatcher(this.repeated, m);
    }

    @Override
    public Matcher rewrite(Function<Matcher, Matcher> f) {
        return f.apply(new ZeroOrMoreMatcher(this.repeated.rewrite(f), this.next.rewrite(f)));
    }

    @Override
    public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        return f.apply(new ZeroOrMoreMatcher(this.repeated, this.next.rewriteEnd(f)));
    }

    public String toString() {
        return "(" + this.repeated + ")*" + (this.next instanceof TrueMatcher ? "" : this.next.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeroOrMoreMatcher that = (ZeroOrMoreMatcher)o;
        return Objects.equals(this.repeated, that.repeated) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.repeated, this.next);
    }
}

