/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.jvm;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import spectator-agent.config.Config;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.patterns.PolledMeter;
import spectator-agent.spectator.jvm.BufferPoolMeter;
import spectator-agent.spectator.jvm.JavaFlightRecorder;
import spectator-agent.spectator.jvm.JmxConfig;
import spectator-agent.spectator.jvm.JmxMeter;
import spectator-agent.spectator.jvm.MemoryPoolMeter;

public final class Jmx {
    private Jmx() {
    }

    public static void registerStandardMXBeans(Registry registry) {
        if (JavaFlightRecorder.isSupported()) {
            ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r, "spectator-jfr");
                t.setDaemon(true);
                return t;
            });
            JavaFlightRecorder.monitorDefaultEvents(registry, executor);
        } else {
            Jmx.monitorClassLoadingMXBean(registry);
            Jmx.monitorThreadMXBean(registry);
            Jmx.monitorCompilationMXBean(registry);
        }
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            registry.register(new MemoryPoolMeter(registry, memoryPoolMXBean));
        }
        for (BufferPoolMXBean bufferPoolMXBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            registry.register(new BufferPoolMeter(registry, bufferPoolMXBean));
        }
    }

    private static void monitorClassLoadingMXBean(Registry registry) {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        PolledMeter.using(registry).withName("jvm.classloading.classesLoaded").monitorMonotonicCounter(classLoadingMXBean, ClassLoadingMXBean::getTotalLoadedClassCount);
        PolledMeter.using(registry).withName("jvm.classloading.classesUnloaded").monitorMonotonicCounter(classLoadingMXBean, ClassLoadingMXBean::getUnloadedClassCount);
    }

    private static void monitorThreadMXBean(Registry registry) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        PolledMeter.using(registry).withName("jvm.thread.threadsStarted").monitorMonotonicCounter(threadMXBean, ThreadMXBean::getTotalStartedThreadCount);
        Gauge nonDaemonThreadCount = registry.gauge("jvm.thread.threadCount", "id", "non-daemon");
        Gauge daemonThreadCount = registry.gauge("jvm.thread.threadCount", "id", "daemon");
        PolledMeter.poll(registry, () -> {
            int threads = threadMXBean.getThreadCount();
            int daemonThreads = threadMXBean.getDaemonThreadCount();
            nonDaemonThreadCount.set(Math.max(0, threads - daemonThreads));
            daemonThreadCount.set(daemonThreads);
        });
    }

    private static void monitorCompilationMXBean(Registry registry) {
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
            ((PolledMeter.Builder)PolledMeter.using(registry).withName("jvm.compilation.compilationTime").withTag("compiler", compilationMXBean.getName())).monitorMonotonicCounterDouble(compilationMXBean, c -> (double)c.getTotalCompilationTime() / 1000.0);
        }
    }

    public static void registerMappingsFromConfig(Registry registry, Config cfg) {
        registry.register(new JmxMeter(registry, JmxConfig.from(cfg)));
    }
}

