/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.jvm;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import jdk.jfr.EventSettings;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Timer;

public class JavaFlightRecorder {
    private static final String PREFIX = "jdk.";
    private static final String ClassLoadingStatistics = "jdk.ClassLoadingStatistics";
    private static final String CompilerStatistics = "jdk.CompilerStatistics";
    private static final String JavaThreadStatistics = "jdk.JavaThreadStatistics";
    private static final String VirtualThreadPinned = "jdk.VirtualThreadPinned";
    private static final String VirtualThreadSubmitFailed = "jdk.VirtualThreadSubmitFailed";
    private static final String YoungGarbageCollection = "jdk.YoungGarbageCollection";
    private static final String ZAllocationStall = "jdk.ZAllocationStall";
    private static final String ZYoungGarbageCollection = "jdk.ZYoungGarbageCollection";

    private JavaFlightRecorder() {
    }

    public static boolean isSupported() {
        try {
            Class.forName("jdk.jfr.consumer.RecordingStream");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static AutoCloseable monitorDefaultEvents(Registry registry, Executor executor) {
        if (!JavaFlightRecorder.isSupported()) {
            throw new UnsupportedOperationException("This JVM does not support Java Flight Recorder event streaming");
        }
        Objects.requireNonNull(registry);
        Objects.requireNonNull(executor);
        RecordingStream rs = new RecordingStream();
        JavaFlightRecorder.collectClassLoadingStatistics((Registry)registry, (RecordingStream)rs);
        JavaFlightRecorder.collectCompilerStatistics((Registry)registry, (RecordingStream)rs);
        JavaFlightRecorder.collectThreadStatistics((Registry)registry, (RecordingStream)rs);
        JavaFlightRecorder.collectVirtualThreadEvents((Registry)registry, (RecordingStream)rs);
        JavaFlightRecorder.collectGcEvents((Registry)registry, (RecordingStream)rs);
        executor.execute(rs::start);
        return rs::close;
    }

    private static void collectClassLoadingStatistics(Registry registry, RecordingStream rs) {
        Counter classesLoaded = registry.counter("jvm.classloading.classesLoaded");
        AtomicLong prevLoadedClassCount = new AtomicLong();
        Counter classesUnloaded = registry.counter("jvm.classloading.classesUnloaded");
        AtomicLong prevUnloadedClassCount = new AtomicLong();
        JavaFlightRecorder.consume((String)ClassLoadingStatistics, (RecordingStream)rs, (T event) -> {
            long loadedClassCount = event.getLong("loadedClassCount");
            loadedClassCount -= prevLoadedClassCount.getAndSet(loadedClassCount);
            classesLoaded.increment(loadedClassCount);
            long unloadedClassCount = event.getLong("unloadedClassCount");
            unloadedClassCount -= prevUnloadedClassCount.getAndSet(unloadedClassCount);
            classesUnloaded.increment(unloadedClassCount);
        });
    }

    private static void collectCompilerStatistics(Registry registry, RecordingStream rs) {
        Counter compilationTime = registry.counter("jvm.compilation.compilationTime");
        AtomicLong prevTotalTimeSpent = new AtomicLong();
        JavaFlightRecorder.consume((String)CompilerStatistics, (RecordingStream)rs, (T event) -> {
            long totalTimeSpent = event.getLong("totalTimeSpent");
            totalTimeSpent -= prevTotalTimeSpent.getAndAdd(totalTimeSpent);
            compilationTime.add((double)totalTimeSpent / 1000.0);
        });
    }

    private static void collectThreadStatistics(Registry registry, RecordingStream rs) {
        Gauge nonDaemonThreadCount = registry.gauge("jvm.thread.threadCount", "id", "non-daemon");
        Gauge daemonThreadCount = registry.gauge("jvm.thread.threadCount", "id", "daemon");
        Counter threadsStarted = registry.counter("jvm.thread.threadsStarted");
        AtomicLong prevAccumulatedCount = new AtomicLong();
        JavaFlightRecorder.consume((String)JavaThreadStatistics, (RecordingStream)rs, (T event) -> {
            long activeCount = event.getLong("activeCount");
            long daemonCount = event.getLong("daemonCount");
            long nonDaemonCount = activeCount - daemonCount;
            nonDaemonThreadCount.set(nonDaemonCount);
            daemonThreadCount.set(daemonCount);
            long accumulatedCount = event.getLong("accumulatedCount");
            accumulatedCount -= prevAccumulatedCount.getAndSet(accumulatedCount);
            threadsStarted.increment(accumulatedCount);
        });
    }

    private static void collectVirtualThreadEvents(Registry registry, RecordingStream rs) {
        Timer pinned = registry.timer("jvm.vt.pinned");
        Counter submitFailed = registry.counter("jvm.vt.submitFailed");
        JavaFlightRecorder.consume((String)VirtualThreadPinned, (RecordingStream)rs, (T event) -> pinned.record(event.getDuration())).withThreshold(Duration.ofMillis(20L));
        JavaFlightRecorder.consume((String)VirtualThreadSubmitFailed, (RecordingStream)rs, (T event) -> submitFailed.increment());
    }

    private static void collectGcEvents(Registry registry, RecordingStream rs) {
        Gauge tenuringThreshold = registry.gauge("jvm.gc.tenuringThreshold");
        Consumer<RecordedEvent> tenuringThresholdFn = event -> tenuringThreshold.set(event.getLong("tenuringThreshold"));
        JavaFlightRecorder.consume((String)YoungGarbageCollection, (RecordingStream)rs, tenuringThresholdFn);
        JavaFlightRecorder.consume((String)ZYoungGarbageCollection, (RecordingStream)rs, tenuringThresholdFn);
        JavaFlightRecorder.consume((String)ZAllocationStall, (RecordingStream)rs, (T event) -> registry.timer("jvm.gc.allocationStall", "type", event.getString("type")).record(event.getDuration()));
    }

    private static EventSettings consume(String name, RecordingStream rs, Consumer<RecordedEvent> consumer) {
        EventSettings settings = rs.enable(name).withoutStackTrace().withThreshold(Duration.ofMillis(0L)).withPeriod(Duration.ofSeconds(5L));
        rs.onEvent(name, consumer);
        return settings;
    }
}

