/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.AtlasTimerBatchUpdater;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.atlas.MeasurementConsumer;
import spectator-agent.spectator.impl.StepDouble;
import spectator-agent.spectator.impl.StepLong;
import spectator-agent.spectator.impl.StepValue;

class AtlasTimer
extends AtlasMeter
implements Timer {
    private final StepLong count;
    private final StepDouble total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasTimer(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.count = new StepLong(0L, clock, step);
        this.total = new StepDouble(0.0, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(DsType.rate, Statistic.count), id.withTags(DsType.rate, Statistic.totalTime), id.withTags(DsType.rate, Statistic.totalOfSquares), id.withTags(DsType.gauge, Statistic.max)};
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        this.reportMeasurement(now, consumer, this.stats[0], this.count, 1.0);
        this.reportMeasurement(now, consumer, this.stats[1], this.total, 1.0E-9);
        this.reportMeasurement(now, consumer, this.stats[2], this.totalOfSquares, 1.0E-18);
        this.reportMaxMeasurement(now, consumer, this.stats[3], this.max);
    }

    private void reportMeasurement(long now, MeasurementConsumer consumer, Id mid, StepValue v, double f) {
        double rate = v.pollAsRate(now) * f;
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, rate);
    }

    private void reportMaxMeasurement(long now, MeasurementConsumer consumer, Id mid, StepLong v) {
        double maxValue = (double)v.poll(now) / 1.0E9;
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, maxValue);
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long now = this.clock.wallTime();
        this.count.incrementAndGet(now);
        if (amount > 0L) {
            long nanos = unit.toNanos(amount);
            this.total.addAndGet(now, nanos);
            this.totalOfSquares.addAndGet(now, (double)nanos * (double)nanos);
            this.max.max(now, nanos);
        }
        this.updateLastModTime(now);
    }

    @Override
    public void record(long[] amounts, int n, TimeUnit unit) {
        int limit = Math.min(Math.max(0, n), amounts.length);
        double accumulatedTotal = 0.0;
        long accumulatedMax = Long.MIN_VALUE;
        double accumulatedTotalOfSquares = 0.0;
        for (int i = 0; i < limit; ++i) {
            long nanos = unit.toNanos(amounts[i]);
            if (nanos <= 0L) continue;
            accumulatedTotal += (double)nanos;
            accumulatedTotalOfSquares += (double)nanos * (double)nanos;
            accumulatedMax = Math.max(nanos, accumulatedMax);
        }
        long now = this.clock.wallTime();
        this.count.addAndGet(now, limit);
        this.total.addAndGet(now, accumulatedTotal);
        this.totalOfSquares.addAndGet(now, accumulatedTotalOfSquares);
        this.max.max(now, accumulatedMax);
        this.updateLastModTime(now);
    }

    @Override
    public void record(Duration[] amounts, int n) {
        int limit = Math.min(Math.max(0, n), amounts.length);
        double accumulatedTotal = 0.0;
        long accumulatedMax = Long.MIN_VALUE;
        double accumulatedTotalOfSquares = 0.0;
        for (int i = 0; i < limit; ++i) {
            long nanos = amounts[i].toNanos();
            if (nanos <= 0L) continue;
            accumulatedTotal += (double)nanos;
            accumulatedTotalOfSquares += (double)nanos * (double)nanos;
            accumulatedMax = Math.max(nanos, accumulatedMax);
        }
        long now = this.clock.wallTime();
        this.count.addAndGet(now, limit);
        this.total.addAndGet(now, accumulatedTotal);
        this.totalOfSquares.addAndGet(now, accumulatedTotalOfSquares);
        this.max.max(now, accumulatedMax);
        this.updateLastModTime(now);
    }

    @Override
    public long count() {
        return this.count.poll();
    }

    @Override
    public long totalTime() {
        return (long)this.total.poll();
    }

    @Override
    public Timer.BatchUpdater batchUpdater(int batchSize) {
        AtlasTimerBatchUpdater updater = new AtlasTimerBatchUpdater(batchSize);
        updater.accept(() -> this);
        return updater;
    }

    void update(long count, double total, double totalOfSquares, long max) {
        long now = this.clock.wallTime();
        this.count.addAndGet(now, count);
        this.total.addAndGet(now, total);
        this.totalOfSquares.addAndGet(now, totalOfSquares);
        this.max.max(now, max);
    }
}

