/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasDistSummaryBatchUpdater;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.atlas.MeasurementConsumer;
import spectator-agent.spectator.impl.StepDouble;
import spectator-agent.spectator.impl.StepLong;
import spectator-agent.spectator.impl.StepValue;

class AtlasDistributionSummary
extends AtlasMeter
implements DistributionSummary {
    private final StepLong count;
    private final StepLong total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasDistributionSummary(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.count = new StepLong(0L, clock, step);
        this.total = new StepLong(0L, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(DsType.rate, Statistic.count), id.withTags(DsType.rate, Statistic.totalAmount), id.withTags(DsType.rate, Statistic.totalOfSquares), id.withTags(DsType.gauge, Statistic.max)};
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        this.reportMeasurement(now, consumer, this.stats[0], this.count);
        this.reportMeasurement(now, consumer, this.stats[1], this.total);
        this.reportMeasurement(now, consumer, this.stats[2], this.totalOfSquares);
        this.reportMaxMeasurement(now, consumer, this.stats[3], this.max);
    }

    private void reportMeasurement(long now, MeasurementConsumer consumer, Id mid, StepValue v) {
        double rate = v.pollAsRate(now);
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, rate);
    }

    private void reportMaxMeasurement(long now, MeasurementConsumer consumer, Id mid, StepLong v) {
        double maxValue = v.poll(now);
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, maxValue);
    }

    @Override
    public void record(long amount) {
        long now = this.clock.wallTime();
        this.count.incrementAndGet(now);
        if (amount > 0L) {
            this.total.addAndGet(now, amount);
            this.totalOfSquares.addAndGet(now, (double)amount * (double)amount);
            this.max.max(now, amount);
        }
        this.updateLastModTime(now);
    }

    @Override
    public void record(long[] amounts, int n) {
        int limit = Math.min(Math.max(0, n), amounts.length);
        long accumulatedTotal = 0L;
        long accumulatedMax = Long.MIN_VALUE;
        double accumulatedTotalOfSquares = 0.0;
        for (int i = 0; i < limit; ++i) {
            if (amounts[i] <= 0L) continue;
            accumulatedTotal += amounts[i];
            accumulatedTotalOfSquares += (double)amounts[i] * (double)amounts[i];
            accumulatedMax = Math.max(amounts[i], accumulatedMax);
        }
        long now = this.clock.wallTime();
        this.count.addAndGet(now, limit);
        this.total.addAndGet(now, accumulatedTotal);
        this.totalOfSquares.addAndGet(now, accumulatedTotalOfSquares);
        this.max.max(now, accumulatedMax);
        this.updateLastModTime(now);
    }

    @Override
    public long count() {
        return this.count.poll();
    }

    @Override
    public long totalAmount() {
        return this.total.poll();
    }

    @Override
    public DistributionSummary.BatchUpdater batchUpdater(int batchSize) {
        AtlasDistSummaryBatchUpdater updater = new AtlasDistSummaryBatchUpdater(batchSize);
        updater.accept(() -> this);
        return updater;
    }

    void update(long count, long total, double totalOfSquares, long max) {
        long now = this.clock.wallTime();
        this.count.addAndGet(now, count);
        this.total.addAndGet(now, total);
        this.totalOfSquares.addAndGet(now, totalOfSquares);
        this.max.max(now, max);
    }
}

