/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import spectator-agent.slf4j.Logger;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.atlas.impl.ValidationResponse;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.ObjectMapper;
import spectator-agent.spectator.ipc.http.HttpResponse;

final class ValidationHelper {
    private final Logger logger;
    private final ObjectMapper jsonMapper;
    private final Counter measurementsSent;
    private final Counter measurementsDroppedInvalid;
    private final Counter measurementsDroppedHttp;
    private final Counter measurementsDroppedOther;

    ValidationHelper(Logger logger, ObjectMapper jsonMapper, Registry registry) {
        this.logger = logger;
        this.jsonMapper = jsonMapper;
        Id baseId = registry.createId("spectator.measurements");
        Id droppedId = baseId.withTag("id", "dropped");
        this.measurementsSent = registry.counter(baseId.withTag("id", "sent"));
        this.measurementsDroppedHttp = registry.counter(droppedId.withTag("error", "http-error"));
        this.measurementsDroppedInvalid = registry.counter(droppedId.withTag("error", "validation"));
        this.measurementsDroppedOther = registry.counter(droppedId.withTag("error", "other"));
    }

    void incrementDroppedHttp(int amount) {
        this.measurementsDroppedHttp.increment(amount);
    }

    void recordResults(int numMeasurements, HttpResponse res) {
        if (res.status() == 200) {
            this.measurementsSent.increment(numMeasurements);
        } else if (res.status() < 500) {
            try {
                ValidationResponse vres = this.jsonMapper.readValue(res.entity(), ValidationResponse.class);
                this.measurementsDroppedInvalid.increment(vres.getErrorCount());
                this.measurementsSent.increment(numMeasurements - vres.getErrorCount());
                this.logger.warn("{} measurement(s) dropped due to validation errors: {}", (Object)vres.getErrorCount(), (Object)vres.errorSummary());
            }
            catch (Exception e) {
                this.logger.trace("failed to parse response", e);
                this.logger.warn("{} measurement(s) dropped. Http status: {}", (Object)numMeasurements, (Object)res.status());
                this.measurementsDroppedOther.increment(numMeasurements);
            }
        } else {
            this.measurementsDroppedHttp.increment(numMeasurements);
        }
    }
}

