/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import spectator-agent.spectator.atlas.impl.Query;
import spectator-agent.spectator.atlas.impl.TagsValuePair;
import spectator-agent.spectator.impl.Preconditions;

public interface DataExpr {
    public Query query();

    public boolean isAccumulating();

    default public boolean isCount() {
        return false;
    }

    public Map<String, String> resultTags(Map<String, String> var1);

    public Aggregator aggregator(Map<String, String> var1, boolean var2);

    default public Aggregator aggregator(boolean shouldCheckQuery) {
        return this.aggregator(this.resultTags(Collections.emptyMap()), shouldCheckQuery);
    }

    default public Iterable<TagsValuePair> eval(Iterable<TagsValuePair> input) {
        Aggregator aggr = this.aggregator(true);
        for (TagsValuePair p : input) {
            aggr.update(p);
        }
        return aggr.result();
    }

    public static final class KeepRollup
    implements DataExpr {
        private final AggregateFunction af;
        private final Set<String> keys;

        KeepRollup(AggregateFunction af, List<String> keys) {
            this.af = af;
            this.keys = new HashSet<String>(keys);
            this.keys.add("name");
        }

        @Override
        public Query query() {
            return this.af.query();
        }

        @Override
        public boolean isAccumulating() {
            return this.af.isAccumulating();
        }

        @Override
        public boolean isCount() {
            return this.af.isCount();
        }

        @Override
        public Map<String, String> resultTags(Map<String, String> tags) {
            return tags.entrySet().stream().filter(e -> this.keys.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @Override
        public Aggregator aggregator(Map<String, String> ignored, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final Map<Map<String, String>, Aggregator> aggrs = new HashMap<Map<String, String>, Aggregator>();

                @Override
                public void update(TagsValuePair p) {
                    if (!shouldCheckQuery || af.query().matches(p.tags())) {
                        Map<String, String> k = this.resultTags(p.tags());
                        this.aggrs.computeIfAbsent(k, ks -> af.aggregator((Map<String, String>)ks, false)).update(p);
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggrs.values().stream().flatMap(a -> StreamSupport.stream(a.result().spliterator(), false)).collect(Collectors.toList());
                }
            };
        }

        public String toString() {
            String keyList = String.join((CharSequence)",", this.keys);
            return this.af.toString() + ",(," + keyList + ",),:rollup-keep";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeepRollup)) {
                return false;
            }
            KeepRollup other = (KeepRollup)obj;
            return this.af.equals(other.af) && this.keys.equals(other.keys);
        }

        public int hashCode() {
            int result = this.af.hashCode();
            result = 31 * result + this.keys.hashCode();
            result = 31 * result + ":by".hashCode();
            return result;
        }
    }

    public static final class DropRollup
    implements DataExpr {
        private final AggregateFunction af;
        private final List<String> keys;

        DropRollup(AggregateFunction af, List<String> keys) {
            Preconditions.checkArg(!keys.contains("name"), "name is required and cannot be dropped");
            this.af = af;
            this.keys = keys;
        }

        @Override
        public Query query() {
            return this.af.query();
        }

        @Override
        public boolean isAccumulating() {
            return this.af.isAccumulating();
        }

        @Override
        public boolean isCount() {
            return this.af.isCount();
        }

        @Override
        public Map<String, String> resultTags(Map<String, String> tags) {
            HashMap<String, String> resultTags = new HashMap<String, String>(tags);
            for (String k : this.keys) {
                resultTags.remove(k);
            }
            return resultTags;
        }

        @Override
        public Aggregator aggregator(Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final Map<Map<String, String>, Aggregator> aggrs = new HashMap<Map<String, String>, Aggregator>();

                @Override
                public void update(TagsValuePair p) {
                    if (!shouldCheckQuery || af.query().matches(p.tags())) {
                        Map<String, String> k = this.resultTags(p.tags());
                        this.aggrs.computeIfAbsent(k, ks -> af.aggregator((Map<String, String>)ks, false)).update(p);
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggrs.values().stream().flatMap(a -> StreamSupport.stream(a.result().spliterator(), false)).collect(Collectors.toList());
                }
            };
        }

        public String toString() {
            String keyList = String.join((CharSequence)",", this.keys);
            return this.af.toString() + ",(," + keyList + ",),:rollup-drop";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DropRollup)) {
                return false;
            }
            DropRollup other = (DropRollup)obj;
            return this.af.equals(other.af) && this.keys.equals(other.keys);
        }

        public int hashCode() {
            int result = this.af.hashCode();
            result = 31 * result + this.keys.hashCode();
            result = 31 * result + ":by".hashCode();
            return result;
        }
    }

    public static final class GroupBy
    implements DataExpr {
        private final AggregateFunction af;
        private final List<String> keys;

        GroupBy(AggregateFunction af, List<String> keys) {
            Preconditions.checkArg(!keys.isEmpty(), "key list for group by cannot be empty");
            this.af = af;
            this.keys = keys;
        }

        private Map<String, String> keyTags(Map<String, String> tags) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String k : this.keys) {
                String v = tags.get(k);
                if (v == null) {
                    return null;
                }
                result.put(k, v);
            }
            return result;
        }

        @Override
        public Query query() {
            return this.af.query();
        }

        @Override
        public boolean isAccumulating() {
            return this.af.isAccumulating();
        }

        @Override
        public boolean isCount() {
            return this.af.isCount();
        }

        @Override
        public Map<String, String> resultTags(Map<String, String> tags) {
            Map<String, String> resultTags = this.keyTags(tags);
            if (resultTags == null) {
                return null;
            }
            resultTags.putAll(this.af.queryTags());
            return resultTags;
        }

        @Override
        public Aggregator aggregator(Map<String, String> ignored, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final Map<Map<String, String>, Aggregator> aggrs = new HashMap<Map<String, String>, Aggregator>();

                @Override
                public void update(TagsValuePair p) {
                    Map<String, String> k;
                    Map<String, String> tags = p.tags();
                    if ((!shouldCheckQuery || af.query().matches(tags)) && (k = this.resultTags(tags)) != null) {
                        this.aggrs.computeIfAbsent(k, ks -> af.aggregator((Map<String, String>)ks, false)).update(p);
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggrs.values().stream().flatMap(a -> StreamSupport.stream(a.result().spliterator(), false)).collect(Collectors.toList());
                }
            };
        }

        public String toString() {
            String keyList = String.join((CharSequence)",", this.keys);
            return this.af.toString() + ",(," + keyList + ",),:by";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GroupBy)) {
                return false;
            }
            GroupBy other = (GroupBy)obj;
            return this.af.equals(other.af) && this.keys.equals(other.keys);
        }

        public int hashCode() {
            int result = this.af.hashCode();
            result = 31 * result + this.keys.hashCode();
            result = 31 * result + ":by".hashCode();
            return result;
        }
    }

    public static final class Count
    implements AggregateFunction {
        private final Query query;
        private final Map<String, String> queryTags;

        Count(Query query) {
            this.query = query;
            this.queryTags = Collections.unmodifiableMap(query.exactTags());
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public boolean isAccumulating() {
            return true;
        }

        @Override
        public boolean isCount() {
            return true;
        }

        @Override
        public Map<String, String> queryTags() {
            return this.queryTags;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private int aggr = 0;

                @Override
                public void update(TagsValuePair p) {
                    if (!shouldCheckQuery || query.matches(p.tags())) {
                        ++this.aggr;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggr > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:count";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Count)) {
                return false;
            }
            Count other = (Count)obj;
            return this.query.equals(other.query) && this.queryTags.equals(other.queryTags);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + this.queryTags.hashCode();
            result = 31 * result + ":count".hashCode();
            return result;
        }
    }

    public static final class Max
    implements AggregateFunction {
        private final Query query;
        private final Map<String, String> queryTags;

        Max(Query query) {
            this.query = query;
            this.queryTags = Collections.unmodifiableMap(query.exactTags());
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public boolean isAccumulating() {
            return false;
        }

        @Override
        public Map<String, String> queryTags() {
            return this.queryTags;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private double aggr = -1.7976931348623157E308;
                private int count = 0;

                @Override
                public void update(TagsValuePair p) {
                    if ((!shouldCheckQuery || query.matches(p.tags())) && p.value() > this.aggr) {
                        this.aggr = p.value();
                        ++this.count;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.count > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:max";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Max)) {
                return false;
            }
            Max other = (Max)obj;
            return this.query.equals(other.query) && this.queryTags.equals(other.queryTags);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + this.queryTags.hashCode();
            result = 31 * result + ":max".hashCode();
            return result;
        }
    }

    public static final class Min
    implements AggregateFunction {
        private final Query query;
        private final Map<String, String> queryTags;

        Min(Query query) {
            this.query = query;
            this.queryTags = Collections.unmodifiableMap(query.exactTags());
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public boolean isAccumulating() {
            return false;
        }

        @Override
        public Map<String, String> queryTags() {
            return this.queryTags;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private double aggr = Double.MAX_VALUE;
                private int count = 0;

                @Override
                public void update(TagsValuePair p) {
                    if ((!shouldCheckQuery || query.matches(p.tags())) && p.value() < this.aggr) {
                        this.aggr = p.value();
                        ++this.count;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.count > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:min";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Min)) {
                return false;
            }
            Min other = (Min)obj;
            return this.query.equals(other.query) && this.queryTags.equals(other.queryTags);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + this.queryTags.hashCode();
            result = 31 * result + ":min".hashCode();
            return result;
        }
    }

    public static final class Sum
    implements AggregateFunction {
        private final Query query;
        private final Map<String, String> queryTags;

        Sum(Query query) {
            this.query = query;
            this.queryTags = Collections.unmodifiableMap(query.exactTags());
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public boolean isAccumulating() {
            return true;
        }

        @Override
        public Map<String, String> queryTags() {
            return this.queryTags;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private double aggr = 0.0;
                private int count = 0;

                @Override
                public void update(TagsValuePair p) {
                    if (!shouldCheckQuery || query.matches(p.tags())) {
                        this.aggr += p.value();
                        ++this.count;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.count > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:sum";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Sum)) {
                return false;
            }
            Sum other = (Sum)obj;
            return this.query.equals(other.query) && this.queryTags.equals(other.queryTags);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + this.queryTags.hashCode();
            result = 31 * result + ":sum".hashCode();
            return result;
        }
    }

    public static interface AggregateFunction
    extends DataExpr {
        public Map<String, String> queryTags();

        @Override
        default public Map<String, String> resultTags(Map<String, String> tags) {
            Map<String, String> ts = this.queryTags();
            return ts.isEmpty() ? Collections.singletonMap("name", "unknown") : ts;
        }
    }

    public static final class All
    implements DataExpr {
        private final Query query;

        All(Query query) {
            this.query = query;
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public boolean isAccumulating() {
            return false;
        }

        @Override
        public Map<String, String> resultTags(Map<String, String> tags) {
            return tags;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final List<TagsValuePair> pairs = new ArrayList<TagsValuePair>();

                @Override
                public void update(TagsValuePair p) {
                    if (!shouldCheckQuery || query.matches(p.tags())) {
                        this.pairs.add(new TagsValuePair(tags, p.value()));
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.pairs;
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:all";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof All)) {
                return false;
            }
            All other = (All)obj;
            return this.query.equals(other.query);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + ":all".hashCode();
            return result;
        }
    }

    public static interface Aggregator {
        public void update(TagsValuePair var1);

        public Iterable<TagsValuePair> result();
    }
}

