/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.ArrayList;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.atlas.MeasurementConsumer;

abstract class AtlasMeter
implements Meter {
    protected final Id id;
    protected final Clock clock;
    private final long ttl;
    private volatile long lastUpdated;

    static Id addIfMissing(Id id, Tag t1, Tag t2) {
        String k1 = t1.key();
        String k2 = t2.key();
        boolean hasT1 = false;
        boolean hasT2 = false;
        for (int i = 1; i < id.size(); ++i) {
            hasT1 = hasT1 || k1.equals(id.getKey(i));
            boolean bl = hasT2 = hasT2 || k2.equals(id.getKey(i));
            if (hasT1 && hasT2) break;
        }
        if (hasT1 && hasT2) {
            return id;
        }
        if (!hasT1 && !hasT2) {
            return id.withTags(t1.key(), t1.value(), t2.key(), t2.value());
        }
        if (!hasT1) {
            return id.withTag(t1);
        }
        return id.withTag(t2);
    }

    AtlasMeter(Id id, Clock clock, long ttl) {
        this.id = id;
        this.clock = clock;
        this.ttl = ttl;
        this.lastUpdated = clock.wallTime();
    }

    void updateLastModTime(long now) {
        this.lastUpdated = now;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return this.hasExpired(this.clock.wallTime());
    }

    boolean hasExpired(long now) {
        return now - this.lastUpdated > this.ttl;
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        this.measure(now, (id, timestamp, value) -> ms.add(new Measurement(id, timestamp, value)));
        return ms;
    }

    abstract void measure(long var1, MeasurementConsumer var3);
}

