/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import spectator-agent.spectator.atlas.impl.Query;
import spectator-agent.spectator.impl.Preconditions;

final class PrefixTree {
    private final Lock lock = new ReentrantLock();
    private volatile Node root;
    private final Set<Query.KeyQuery> otherQueries = PrefixTree.newSet();
    private static final Node[] EMPTY = new Node[0];

    PrefixTree() {
    }

    private Node addQuery(Node node, Query.KeyQuery query) {
        if (query instanceof Query.In) {
            Query.In q = (Query.In)query;
            node.inQueries.add(q);
        } else {
            node.otherQueries.add(query);
        }
        return node;
    }

    private boolean removeQuery(Node node, Query.KeyQuery query) {
        if (query instanceof Query.In) {
            Query.In q = (Query.In)query;
            return node.inQueries.remove(q);
        }
        return node.otherQueries.remove(query);
    }

    void put(Query.KeyQuery query) {
        if (query instanceof Query.In) {
            Query.In q = (Query.In)query;
            for (String v : q.values()) {
                this.put(v, q);
            }
        } else if (query instanceof Query.Regex) {
            Query.Regex q = (Query.Regex)query;
            this.put(q.pattern().prefix(), q);
        } else {
            this.otherQueries.add(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String prefix, Query.KeyQuery value) {
        if (prefix == null) {
            this.otherQueries.add(value);
        } else {
            this.lock.lock();
            try {
                Node node = this.root;
                if (node == null) {
                    this.root = new Node(prefix, EMPTY);
                    this.addQuery(this.root, value);
                } else {
                    this.root = this.putImpl(node, prefix, 0, value);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private Node putImpl(Node node, String key, int offset, Query.KeyQuery value) {
        int prefixLength = node.prefix.length();
        int keyLength = key.length() - offset;
        int commonLength = PrefixTree.commonPrefixLength(node.prefix, key, offset);
        if (commonLength == 0 && prefixLength > 0) {
            Node n = this.addQuery(new Node(key.substring(offset), EMPTY), value);
            return new Node("", new Node[]{n, node});
        }
        if (keyLength == prefixLength && commonLength == prefixLength) {
            this.addQuery(node, value);
            return node;
        }
        if (keyLength > prefixLength && commonLength == prefixLength) {
            int childOffset = offset + commonLength;
            int pos = PrefixTree.find(node.children, key, childOffset);
            if (pos >= 0) {
                Node n = this.putImpl(node.children[pos], key, childOffset, value);
                return node.replaceChild(n, pos);
            }
            Node n = this.addQuery(new Node(key.substring(childOffset), EMPTY), value);
            return node.addChild(n);
        }
        if (prefixLength > keyLength && commonLength == keyLength) {
            int childOffset = offset + commonLength;
            Node n = new Node(node.prefix.substring(commonLength), node.children, node.inQueries, node.otherQueries);
            return this.addQuery(new Node(key.substring(offset, childOffset), new Node[]{n}), value);
        }
        int childOffset = offset + commonLength;
        Node[] children = new Node[]{new Node(node.prefix.substring(commonLength), node.children, node.inQueries, node.otherQueries), this.addQuery(new Node(key.substring(childOffset), EMPTY), value)};
        return new Node(node.prefix.substring(0, commonLength), children);
    }

    boolean remove(Query.KeyQuery query) {
        if (query instanceof Query.In) {
            boolean removed = false;
            Query.In q = (Query.In)query;
            for (String v : q.values()) {
                removed |= this.remove(v, q);
            }
            return removed;
        }
        if (query instanceof Query.Regex) {
            Query.Regex q = (Query.Regex)query;
            return this.remove(q.pattern().prefix(), q);
        }
        return this.otherQueries.remove(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(String prefix, Query.KeyQuery value) {
        if (prefix == null) {
            return this.otherQueries.remove(value);
        }
        this.lock.lock();
        try {
            boolean removed = false;
            Node node = this.root;
            if (node != null && (removed = this.removeImpl(node, prefix, 0, value))) {
                this.root = (node = node.compress()).isEmpty() ? null : node;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean removeImpl(Node node, String key, int offset, Query.KeyQuery value) {
        int prefixLength = node.prefix.length();
        int keyLength = key.length() - offset;
        int commonLength = PrefixTree.commonPrefixLength(node.prefix, key, offset);
        if (keyLength == prefixLength && commonLength == prefixLength) {
            return this.removeQuery(node, value);
        }
        if (keyLength > prefixLength && commonLength == prefixLength) {
            int childOffset = offset + commonLength;
            int pos = PrefixTree.find(node.children, key, childOffset);
            return pos >= 0 && this.removeImpl(node.children[pos], key, childOffset, value);
        }
        return false;
    }

    List<Query.KeyQuery> get(String key) {
        ArrayList<Query.KeyQuery> result = new ArrayList<Query.KeyQuery>();
        this.forEach(key, result::add);
        return result;
    }

    void forEach(String key, Consumer<Query.KeyQuery> consumer) {
        this.otherQueries.forEach(consumer);
        Node node = this.root;
        if (node != null) {
            this.forEachImpl(node, key, 0, consumer);
        }
    }

    private void forEachImpl(Node node, String key, int offset, Consumer<Query.KeyQuery> consumer) {
        int prefixLength = node.prefix.length();
        int keyLength = key.length() - offset;
        int commonLength = PrefixTree.commonPrefixLength(node.prefix, key, offset);
        if (commonLength == prefixLength) {
            node.otherQueries.forEach(consumer);
            if (commonLength < keyLength) {
                int childOffset = offset + commonLength;
                int pos = PrefixTree.find(node.children, key, childOffset);
                if (pos >= 0) {
                    this.forEachImpl(node.children[pos], key, childOffset, consumer);
                }
            } else {
                node.inQueries.forEach(consumer);
            }
        }
    }

    boolean isEmpty() {
        return this.otherQueries.isEmpty() && (this.root == null || this.root.isEmpty());
    }

    int size() {
        Node r = this.root;
        return (r == null ? 0 : r.size()) + this.otherQueries.size();
    }

    static int commonPrefixLength(String str1, String str2, int offset) {
        int length = Math.min(str1.length(), str2.length() - offset);
        for (int i = 0; i < length; ++i) {
            if (str1.charAt(i) == str2.charAt(offset + i)) continue;
            return i;
        }
        return length;
    }

    private static int find(Node[] nodes, String key, int offset) {
        int s = 0;
        int e = nodes.length - 1;
        while (s <= e) {
            int mid = s + e >>> 1;
            int cmp = Character.compare(nodes[mid].prefix.charAt(0), key.charAt(offset));
            if (cmp == 0) {
                return mid;
            }
            if (cmp < 0) {
                s = mid + 1;
                continue;
            }
            e = mid - 1;
        }
        return -1;
    }

    private static <T> Set<T> newSet() {
        return new CopyOnWriteArraySet();
    }

    private static Set<Query.KeyQuery> asSet(Query.KeyQuery value) {
        Set<Query.KeyQuery> set = PrefixTree.newSet();
        set.add(value);
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefixTree that = (PrefixTree)o;
        return Objects.equals(this.root, that.root) && this.otherQueries.equals(that.otherQueries);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.otherQueries);
    }

    private static class Node {
        final String prefix;
        final Node[] children;
        final Set<Query.In> inQueries;
        final Set<Query.KeyQuery> otherQueries;

        Node(String prefix, Node[] children, Set<Query.In> inQueries, Set<Query.KeyQuery> otherQueries) {
            this.prefix = Preconditions.checkNotNull(prefix, "prefix");
            this.children = Preconditions.checkNotNull(children, "children");
            this.inQueries = Preconditions.checkNotNull(inQueries, "inQueries");
            this.otherQueries = Preconditions.checkNotNull(otherQueries, "otherQueries");
            Arrays.sort(children, Comparator.comparing(n -> n.prefix));
        }

        Node(String prefix, Node[] children) {
            this(prefix, children, PrefixTree.newSet(), PrefixTree.newSet());
        }

        Node replaceChild(Node n, int i) {
            Node[] cs = new Node[this.children.length];
            System.arraycopy(this.children, 0, cs, 0, i);
            cs[i] = n;
            System.arraycopy(this.children, i + 1, cs, i + 1, this.children.length - i - 1);
            return new Node(this.prefix, cs, this.inQueries, this.otherQueries);
        }

        Node addChild(Node n) {
            Node[] cs = new Node[this.children.length + 1];
            System.arraycopy(this.children, 0, cs, 0, this.children.length);
            cs[this.children.length] = n;
            return new Node(this.prefix, cs, this.inQueries, this.otherQueries);
        }

        Node compress() {
            ArrayList<Node> cs = null;
            for (int i = 0; i < this.children.length; ++i) {
                Node child = this.children[i];
                Node c = child.compress();
                if (c != child || c.isEmpty()) {
                    if (cs == null) {
                        cs = new ArrayList<Node>(this.children.length);
                        for (int j = 0; j < i; ++j) {
                            cs.add(this.children[j]);
                        }
                    }
                    if (c.isEmpty()) continue;
                    cs.add(c);
                    continue;
                }
                if (cs == null) continue;
                cs.add(child);
            }
            if (cs == null) {
                return this;
            }
            if (this.inQueries.isEmpty() && this.otherQueries.isEmpty() && cs.size() == 1) {
                Node c = (Node)cs.get(0);
                String p = this.prefix + c.prefix;
                return new Node(p, EMPTY, c.inQueries, c.otherQueries);
            }
            return new Node(this.prefix, cs.toArray(EMPTY), this.inQueries, this.otherQueries);
        }

        boolean isEmpty() {
            return this.inQueries.isEmpty() && this.otherQueries.isEmpty() && this.areAllChildrenEmpty();
        }

        private boolean areAllChildrenEmpty() {
            for (Node child : this.children) {
                if (child.isEmpty()) continue;
                return false;
            }
            return true;
        }

        int size() {
            int sz = this.inQueries.size() + this.otherQueries.size();
            for (Node child : this.children) {
                sz += child.size();
            }
            return sz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.prefix.equals(node.prefix) && Arrays.equals(this.children, node.children) && this.inQueries.equals(node.inQueries) && this.otherQueries.equals(node.otherQueries);
        }

        public int hashCode() {
            int result = Objects.hash(this.prefix, this.inQueries, this.otherQueries);
            result = 31 * result + Arrays.hashCode(this.children);
            return result;
        }
    }
}

