/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.gc;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.util.Comparator;
import java.util.Date;
import spectator-agent.spectator.gc.GcType;
import spectator-agent.spectator.gc.HelperFunctions;

public class GcEvent {
    private static final long ONE_KIBIBYTE = 1024L;
    private static final long ONE_MEBIBYTE = 0x100000L;
    private static final long ONE_GIBIBYTE = 0x40000000L;
    private final String name;
    private final GarbageCollectionNotificationInfo info;
    private final GcType type;
    private final long startTime;
    public static final Comparator<GcEvent> TIME_ORDER = Comparator.comparing(GcEvent::getStartTime);
    public static final Comparator<GcEvent> REVERSE_TIME_ORDER = TIME_ORDER.reversed();

    public GcEvent(GarbageCollectionNotificationInfo info, long startTime) {
        this.name = info.getGcName();
        this.info = info;
        this.type = HelperFunctions.getGcType(this.name);
        this.startTime = startTime;
    }

    public GcType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public GarbageCollectionNotificationInfo getInfo() {
        return this.info;
    }

    public String toString() {
        GcInfo gcInfo = this.info.getGcInfo();
        long totalBefore = HelperFunctions.getTotalUsage(gcInfo.getMemoryUsageBeforeGc());
        long totalAfter = HelperFunctions.getTotalUsage(gcInfo.getMemoryUsageAfterGc());
        long max = HelperFunctions.getTotalMaxUsage(gcInfo.getMemoryUsageAfterGc());
        String unit = "KiB";
        double cnv = 1024.0;
        if (max > 0x40000000L) {
            unit = "GiB";
            cnv = 1.073741824E9;
        } else if (max > 0x100000L) {
            unit = "MiB";
            cnv = 1048576.0;
        }
        String change = String.format("%.1f%s => %.1f%s / %.1f%s", (double)totalBefore / cnv, unit, (double)totalAfter / cnv, unit, (double)max / cnv, unit);
        String percentChange = String.format("%.1f%% => %.1f%%", 100.0 * (double)totalBefore / (double)max, 100.0 * (double)totalAfter / (double)max);
        Date d = new Date(this.startTime);
        return this.type.toString() + ": " + this.name + ", id=" + gcInfo.getId() + ", at=" + d.toString() + ", duration=" + gcInfo.getDuration() + "ms, cause=[" + this.info.getGcCause() + "], " + change + " (" + percentChange + ")";
    }
}

