/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.atlas.MeasurementConsumer;
import spectator-agent.spectator.impl.StepDouble;

class AtlasCounter
extends AtlasMeter
implements Counter {
    private final StepDouble value;
    private final Id stat;

    AtlasCounter(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = AtlasMeter.addIfMissing(id, Statistic.count, DsType.rate);
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        double rate = this.value.pollAsRate(now);
        consumer.accept(this.stat, this.value.timestamp(), rate);
    }

    @Override
    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            long now = this.clock.wallTime();
            this.value.getCurrent(now).addAndGet(amount);
            this.updateLastModTime(now);
        }
    }

    @Override
    public double actualCount() {
        return this.value.poll();
    }
}

