/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.histogram;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import spectator-agent.spectator.api.BasicTag;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.api.Utils;
import spectator-agent.spectator.api.histogram.PercentileBuckets;
import spectator-agent.spectator.api.patterns.IdBuilder;
import spectator-agent.spectator.api.patterns.TagsBuilder;

public final class PercentileTimer
implements Timer {
    private static final String[] TAG_VALUES;
    private final Registry registry;
    private final Id id;
    private final Timer timer;
    private final long min;
    private final long max;
    private final AtomicReferenceArray<Counter> counters;

    private static PercentileTimer computeIfAbsent(Registry registry, Id id, long min, long max) {
        Object timer = Utils.computeIfAbsent(registry.state(), id, i -> new PercentileTimer(registry, id, min, max));
        return timer instanceof PercentileTimer ? ((PercentileTimer)timer).withRange(min, max) : new PercentileTimer(registry, id, min, max);
    }

    public static PercentileTimer get(Registry registry, Id id) {
        return PercentileTimer.computeIfAbsent(registry, id, 0L, Long.MAX_VALUE);
    }

    public static IdBuilder<Builder> builder(Registry registry) {
        return new IdBuilder<Builder>(registry){

            @Override
            protected Builder createTypeBuilder(Id id) {
                return new Builder(this.registry, id);
            }
        };
    }

    private PercentileTimer(Registry registry, Id id, long min, long max) {
        this(registry, id, min, max, new AtomicReferenceArray<Counter>(PercentileBuckets.length()));
    }

    private PercentileTimer(Registry registry, Id id, long min, long max, AtomicReferenceArray<Counter> counters) {
        this.registry = registry;
        this.id = id;
        this.timer = registry.timer(id);
        this.min = min;
        this.max = max;
        this.counters = counters;
    }

    private PercentileTimer withRange(long min, long max) {
        return this.min == min && this.max == max ? this : new PercentileTimer(this.registry, this.id, min, max, this.counters);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return this.timer.hasExpired();
    }

    private Counter counterFor(int i) {
        Counter c = this.counters.get(i);
        if (c == null) {
            Id counterId = this.id.withTags(Statistic.percentile, new BasicTag("percentile", TAG_VALUES[i]));
            c = this.registry.counter(counterId);
            this.counters.set(i, c);
        }
        return c;
    }

    private long restrict(long amount) {
        long v = Math.min(amount, this.max);
        return Math.max(v, this.min);
    }

    @Override
    public Clock clock() {
        return this.registry.clock();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanos = this.restrict(unit.toNanos(amount));
        this.timer.record(amount, unit);
        this.counterFor(PercentileBuckets.indexOf(nanos)).increment();
    }

    public double percentile(double p) {
        long[] counts = new long[PercentileBuckets.length()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.counterFor(i).count();
        }
        double v = PercentileBuckets.percentile(counts, p);
        return v / 1.0E9;
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public long totalTime() {
        return this.timer.totalTime();
    }

    static {
        int length = PercentileBuckets.length();
        TAG_VALUES = new String[length];
        for (int i = 0; i < length; ++i) {
            PercentileTimer.TAG_VALUES[i] = String.format("T%04X", i);
        }
    }

    public static final class Builder
    extends TagsBuilder<Builder> {
        private Registry registry;
        private Id baseId;
        private long min;
        private long max;

        Builder(Registry registry, Id baseId) {
            this.registry = registry;
            this.baseId = baseId;
            this.min = TimeUnit.MILLISECONDS.toNanos(10L);
            this.max = TimeUnit.MINUTES.toNanos(1L);
        }

        public Builder withRange(Duration min, Duration max) {
            return this.withRange(min.toNanos(), max.toNanos(), TimeUnit.NANOSECONDS);
        }

        public Builder withRange(long min, long max, TimeUnit unit) {
            this.min = unit.toNanos(min);
            this.max = unit.toNanos(max);
            return this;
        }

        public PercentileTimer build() {
            Id id = this.baseId.withTags(this.extraTags);
            return PercentileTimer.computeIfAbsent(this.registry, id, this.min, this.max);
        }
    }
}

