/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.agent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import spectator-agent.config.Config;
import spectator-agent.config.ConfigFactory;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Spectator;
import spectator-agent.spectator.atlas.AtlasConfig;
import spectator-agent.spectator.atlas.AtlasRegistry;
import spectator-agent.spectator.gc.GcLogger;
import spectator-agent.spectator.jvm.Jmx;
import spectator-agent.spectator.jvm.JmxPoller;
import spectator-agent.spectator.nflx.tagging.NetflixTagging;

public final class Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Agent.class);

    private Agent() {
    }

    static List<Object> parseResourceList(String userResources) {
        ArrayList<Object> resources = new ArrayList<Object>();
        if (userResources != null && !"".equals(userResources)) {
            for (String userResource : userResources.split("[,\\s]+")) {
                if (userResource.startsWith("file:")) {
                    File file = new File(userResource.substring("file:".length()));
                    resources.add(file);
                    continue;
                }
                resources.add(userResource);
            }
        }
        return resources;
    }

    static List<File> findUpdatedConfigs(List<Object> resources, long timestamp) {
        return resources.stream().filter(r -> r instanceof File && ((File)r).lastModified() > timestamp).map(r -> (File)r).collect(Collectors.toList());
    }

    static Config loadConfig(List<Object> resources) {
        Config config = ConfigFactory.load("agent");
        for (Object r : resources) {
            Config user;
            if (r instanceof File) {
                File file = (File)r;
                LOGGER.info("loading configuration from file: {}", (Object)file);
                user = ConfigFactory.parseFile(file);
                config = user.withFallback(config);
                continue;
            }
            String userResource = (String)r;
            LOGGER.info("loading configuration from resource: {}", (Object)userResource);
            user = ConfigFactory.parseResourcesAnySyntax(userResource);
            config = user.withFallback(config);
        }
        return config.resolve().getConfig("netflix.spectator.agent");
    }

    private static void createDependencyProperties(Config config) {
        if (config.hasPath("dependencies")) {
            List<String> deps = config.getStringList("dependencies");
            for (int i = 0; i < deps.size(); ++i) {
                String prop = String.format("netflix.spectator.agent.dependency.%03d", i);
                System.setProperty(prop, deps.get(i));
            }
        }
    }

    public static void premain(String arg, Instrumentation instrumentation) throws Exception {
        List<Object> resources = Agent.parseResourceList(arg);
        Config config = Agent.loadConfig(resources);
        LOGGER.debug("loaded configuration: {}", (Object)config.root().render());
        Agent.createDependencyProperties(config);
        AtlasRegistry registry = new AtlasRegistry(Clock.SYSTEM, new AgentAtlasConfig(config));
        Spectator.globalRegistry().add(registry);
        GcLogger gcLogger = new GcLogger();
        if (config.getBoolean("collection.gc")) {
            gcLogger.start(null);
        }
        if (config.getBoolean("collection.jvm")) {
            Jmx.registerStandardMXBeans(registry);
        }
        if (config.getBoolean("collection.jmx")) {
            ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "spectator-agent-jmx");
                t.setDaemon(true);
                return t;
            });
            Duration step = Duration.parse(config.getString("atlas.step"));
            long delay = Math.max(1000L, step.toMillis() / 2L);
            AtomicLong lastUpdated = new AtomicLong(System.currentTimeMillis());
            JmxPoller poller = new JmxPoller(registry);
            poller.updateConfigs(config.getConfigList("jmx.mappings"));
            exec.scheduleWithFixedDelay(() -> {
                try {
                    List<File> updatedConfigs = Agent.findUpdatedConfigs(resources, lastUpdated.get());
                    if (!updatedConfigs.isEmpty()) {
                        LOGGER.info("detected updated config files: {}", (Object)updatedConfigs);
                        lastUpdated.set(System.currentTimeMillis());
                        Config cfg = Agent.loadConfig(resources);
                        poller.updateConfigs(cfg.getConfigList("jmx.mappings"));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("failed to update jmx config mappings, using previous config", e);
                }
                poller.poll();
            }, delay, delay, TimeUnit.MILLISECONDS);
        }
        registry.start();
        Runtime.getRuntime().addShutdownHook(new Thread(registry::stop, "spectator-agent-shutdown"));
    }

    private static class AgentAtlasConfig
    implements AtlasConfig {
        private final Config config;

        AgentAtlasConfig(Config config) {
            this.config = config;
        }

        @Override
        public String get(String k) {
            return this.config.hasPath(k) ? this.config.getString(k) : null;
        }

        @Override
        public Map<String, String> commonTags() {
            Map<String, String> tags = NetflixTagging.commonTagsForAtlas();
            for (Config config : this.config.getConfigList("atlas.tags")) {
                String value = config.getString("value");
                if (value.isEmpty()) continue;
                tags.put(config.getString("key"), config.getString("value"));
            }
            return tags;
        }
    }
}

