/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Collections;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.impl.AtomicDouble;

class DefaultGauge
implements Gauge {
    private final Clock clock;
    private final Id id;
    private final AtomicDouble value;

    DefaultGauge(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.value = new AtomicDouble(Double.NaN);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void set(double v) {
        this.value.set(v);
    }

    @Override
    public double value() {
        return this.value.get();
    }
}

