/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.jvm;

import java.util.Collections;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.jvm.JmxConfig;
import spectator-agent.spectator.jvm.JmxData;
import spectator-agent.spectator.jvm.JmxMeasurementConfig;

final class JmxMeter
implements Meter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMeter.class);
    private final Registry registry;
    private final JmxConfig config;
    private final Id id;

    JmxMeter(Registry registry, JmxConfig config) {
        this.registry = registry;
        this.config = config;
        this.id = registry.createId(config.getQuery().getCanonicalName());
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        try {
            for (JmxData data : JmxData.query(this.config.getQuery())) {
                for (JmxMeasurementConfig cfg : this.config.getMeasurements()) {
                    cfg.measure(this.registry, data);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to query jmx data: {}", (Object)this.config.getQuery().getCanonicalName(), (Object)e);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

